/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import com.google.protobuf.ByteString;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgScanQuery;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.grpc.common.Header;
import org.apache.hugegraph.store.grpc.common.ScanMethod;
import org.apache.hugegraph.store.grpc.stream.ScanCondition;
import org.apache.hugegraph.store.grpc.stream.ScanQueryRequest;
import org.apache.hugegraph.store.grpc.stream.ScanStreamBatchReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class KvBatchUtil {
    private static final Logger log = LoggerFactory.getLogger(KvBatchUtil.class);
    static final byte[] EMPTY_POSITION = HgStoreClientConst.EMPTY_BYTES;

    KvBatchUtil() {
    }

    static ScanStreamBatchReq.Builder getRequestBuilder(HgStoreNodeSession nodeSession) {
        return ScanStreamBatchReq.newBuilder().setHeader(KvBatchUtil.getHeader(nodeSession));
    }

    static ScanQueryRequest createQueryReq(HgScanQuery scanQuery, long pageSize) {
        ScanQueryRequest.Builder qb = ScanQueryRequest.newBuilder();
        ScanCondition.Builder cb = ScanCondition.newBuilder();
        qb.setLimit(KvBatchUtil.getLimit(scanQuery.getLimit()));
        qb.setPerKeyLimit(KvBatchUtil.getLimit(scanQuery.getPerKeyLimit()));
        qb.setPerKeyMax(KvBatchUtil.getLimit(scanQuery.getPerKeyMax()));
        switch (scanQuery.getScanMethod()) {
            case ALL: {
                qb.setMethod(ScanMethod.ALL);
                break;
            }
            case PREFIX: {
                qb.setMethod(ScanMethod.PREFIX);
                KvBatchUtil.addPrefixCondition(scanQuery, qb, cb);
                break;
            }
            case RANGE: {
                qb.setMethod(ScanMethod.RANGE);
                KvBatchUtil.addRangeCondition(scanQuery, qb, cb);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported ScanType: " + String.valueOf((Object)scanQuery.getScanMethod()));
            }
        }
        qb.setTable(scanQuery.getTable());
        qb.setPageSize(pageSize);
        qb.setQuery(KvBatchUtil.toBs(scanQuery.getQuery()));
        qb.setScanType(scanQuery.getScanType());
        qb.setOrderType(scanQuery.getOrderType());
        qb.setSkipDegree(scanQuery.getSkipDegree());
        return qb.build();
    }

    static long getLimit(long limit) {
        return limit <= 0L ? Integer.MAX_VALUE : limit;
    }

    static Header getHeader(HgStoreNodeSession nodeSession) {
        return Header.newBuilder().setGraph(nodeSession.getGraphName()).build();
    }

    static void addPrefixCondition(HgScanQuery scanQuery, ScanQueryRequest.Builder qb, ScanCondition.Builder cb) {
        List<HgOwnerKey> prefixList = scanQuery.getPrefixList();
        if (prefixList == null || prefixList.isEmpty()) {
            throw new RuntimeException("The start-list of ScanQuery shouldn't to be invalid in ScanMethod.PREFIX mode.");
        }
        prefixList.forEach(e -> qb.addCondition(cb.clear().setPrefix(KvBatchUtil.toBs(e.getKey())).setCode(e.getKeyCode()).setSerialNo(e.getSerialNo()).build()));
    }

    static void addRangeCondition(HgScanQuery scanQuery, ScanQueryRequest.Builder qb, ScanCondition.Builder cb) {
        List<HgOwnerKey> startList = scanQuery.getStartList();
        List<HgOwnerKey> endList = scanQuery.getEndList();
        if (startList == null || startList.isEmpty()) {
            throw new RuntimeException("The start-list of ScanQuery shouldn't to be invalid in ScanMethod.RANGE mode.");
        }
        if (endList == null || endList.isEmpty()) {
            throw new RuntimeException("The end-list of ScanQuery shouldn't to be invalid in ScanMethod.RANGE mode.");
        }
        if (startList.size() != endList.size()) {
            throw new RuntimeException("The size of start-list not equals end-list's.");
        }
        int s = startList.size();
        for (int i = 0; i < s; ++i) {
            HgOwnerKey start = startList.get(i);
            HgOwnerKey end = endList.get(i);
            qb.addCondition(cb.clear().setCode(start.getKeyCode()).setStart(KvBatchUtil.toBs(start.getKey())).setEnd(KvBatchUtil.toBs(end.getKey())).setSerialNo(start.getSerialNo()).build());
        }
    }

    static HgOwnerKey toOk(HgOwnerKey key) {
        return key == null ? HgStoreClientConst.EMPTY_OWNER_KEY : key;
    }

    static ByteString toBs(byte[] bytes) {
        return ByteString.copyFrom((byte[])(bytes != null ? bytes : HgStoreClientConst.EMPTY_BYTES));
    }
}

