/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.similarity;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.Consumers;
import org.apache.hugegraph.traversal.algorithm.FusiformSimilarityTraverser;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.ParameterUtil;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class FusiformSimilarityAlgorithm
extends AbstractAlgorithm {
    public static final String ALGO_NAME = "fusiform_similarity";
    public static final String KEY_MIN_NEIGHBORS = "min_neighbors";
    public static final String KEY_MIN_SIMILARS = "min_similars";
    public static final String KEY_TOP_SIMILARS = "top_similars";
    public static final String KEY_GROUP_PROPERTY = "group_property";
    public static final String KEY_MIN_GROUPS = "min_groups";
    public static final int DEFAULT_MIN_NEIGHBORS = 10;
    public static final int DEFAULT_MIN_SIMILARS = 6;
    public static final int DEFAULT_TOP_SIMILARS = 0;
    public static final int DEFAULT_MIN_GROUPS = 0;

    @Override
    public String category() {
        return "similarity";
    }

    @Override
    public String name() {
        return ALGO_NAME;
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        FusiformSimilarityAlgorithm.minNeighbors(parameters);
        FusiformSimilarityAlgorithm.alpha(parameters);
        FusiformSimilarityAlgorithm.minSimilars(parameters);
        FusiformSimilarityAlgorithm.topSimilars(parameters);
        FusiformSimilarityAlgorithm.groupProperty(parameters);
        FusiformSimilarityAlgorithm.minGroups(parameters);
        FusiformSimilarityAlgorithm.degree(parameters);
        FusiformSimilarityAlgorithm.limit(parameters);
        FusiformSimilarityAlgorithm.sourceLabel(parameters);
        FusiformSimilarityAlgorithm.sourceCLabel(parameters);
        FusiformSimilarityAlgorithm.direction(parameters);
        FusiformSimilarityAlgorithm.edgeLabel(parameters);
        FusiformSimilarityAlgorithm.workers(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        int workers = FusiformSimilarityAlgorithm.workers(parameters);
        try (Traverser traverser = new Traverser(job, workers);){
            Object object = traverser.fusiformSimilars(FusiformSimilarityAlgorithm.sourceLabel(parameters), FusiformSimilarityAlgorithm.sourceCLabel(parameters), FusiformSimilarityAlgorithm.direction(parameters), FusiformSimilarityAlgorithm.edgeLabel(parameters), FusiformSimilarityAlgorithm.minNeighbors(parameters), FusiformSimilarityAlgorithm.alpha(parameters), FusiformSimilarityAlgorithm.minSimilars(parameters), FusiformSimilarityAlgorithm.topSimilars(parameters), FusiformSimilarityAlgorithm.groupProperty(parameters), FusiformSimilarityAlgorithm.minGroups(parameters), FusiformSimilarityAlgorithm.degree(parameters), FusiformSimilarityAlgorithm.limit(parameters));
            return object;
        }
    }

    protected static int minNeighbors(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_MIN_NEIGHBORS)) {
            return 10;
        }
        int minNeighbors = ParameterUtil.parameterInt(parameters, KEY_MIN_NEIGHBORS);
        HugeTraverser.checkPositive(minNeighbors, KEY_MIN_NEIGHBORS);
        return minNeighbors;
    }

    protected static int minSimilars(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_MIN_SIMILARS)) {
            return 6;
        }
        int minSimilars = ParameterUtil.parameterInt(parameters, KEY_MIN_SIMILARS);
        HugeTraverser.checkPositive(minSimilars, KEY_MIN_SIMILARS);
        return minSimilars;
    }

    protected static int topSimilars(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_TOP_SIMILARS)) {
            return 0;
        }
        int minSimilars = ParameterUtil.parameterInt(parameters, KEY_TOP_SIMILARS);
        HugeTraverser.checkNonNegative(minSimilars, KEY_TOP_SIMILARS);
        return minSimilars;
    }

    protected static String groupProperty(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_GROUP_PROPERTY)) {
            return null;
        }
        return ParameterUtil.parameterString(parameters, KEY_GROUP_PROPERTY);
    }

    protected static int minGroups(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_MIN_GROUPS)) {
            return 0;
        }
        int minGroups = ParameterUtil.parameterInt(parameters, KEY_MIN_GROUPS);
        HugeTraverser.checkPositive(minGroups, KEY_MIN_GROUPS);
        return minGroups;
    }

    protected static long limit(Map<String, Object> parameters) {
        if (!parameters.containsKey("limit")) {
            return 100L;
        }
        long limit = ParameterUtil.parameterLong(parameters, "limit");
        HugeTraverser.checkLimit(limit);
        return limit;
    }

    private static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        public Traverser(UserJob<Object> job, int workers) {
            super(job, FusiformSimilarityAlgorithm.ALGO_NAME, workers);
        }

        public Object fusiformSimilars(String sourceLabel, String sourceCLabel, Directions direction, String label, int minNeighbors, double alpha, int minSimilars, long topSimilars, String groupProperty, int minGroups, long degree, long limit) {
            HugeGraph graph = this.graph();
            FusiformSimilarityTraverser traverser = new FusiformSimilarityTraverser(graph);
            AtomicLong count = new AtomicLong(0L);
            AbstractAlgorithm.JsonMap similarsJson = new AbstractAlgorithm.JsonMap();
            similarsJson.startObject();
            this.traverse(sourceLabel, sourceCLabel, v -> {
                FusiformSimilarityTraverser.SimilarsMap similars = traverser.fusiformSimilarity(IteratorUtils.of((Object)v), direction, label, minNeighbors, alpha, minSimilars, (int)topSimilars, groupProperty, minGroups, degree, 100000000L, -1L, true);
                if (similars.isEmpty()) {
                    return;
                }
                String result = JsonUtil.toJson(similars.toMap());
                result = result.substring(1, result.length() - 1);
                AbstractAlgorithm.JsonMap jsonMap = similarsJson;
                synchronized (jsonMap) {
                    if (count.incrementAndGet() > limit && limit != -1L) {
                        throw new Consumers.StopExecution("exceed limit %s", limit);
                    }
                    similarsJson.appendRaw(result);
                }
            });
            similarsJson.endObject();
            return similarsJson.asJson();
        }
    }
}

