/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apdplat.word.corpus.Bigram;
import org.apdplat.word.recognition.RecognitionTool;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class MaxNgramScore
extends AbstractSegmentation {
    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.MaxNgramScore;
    }

    @Override
    public List<Word> segImpl(String string) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = string.length();
        Node node = new Node("S", 0);
        node.score = Float.valueOf(0.0f);
        Node node2 = new Node("END", n6 + 1);
        Node[][] nodeArray = new Node[n6 + 2][0];
        nodeArray[0] = new Node[]{node};
        nodeArray[n6 + 1] = new Node[]{node2};
        if (this.isParallelSeg()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n6);
            for (n5 = 0; n5 < n6; ++n5) {
                arrayList.add(n5);
            }
            arrayList.parallelStream().forEach(n -> {
                nodeArray[n.intValue() + 1] = this.fullSeg(string, (int)n);
            });
        } else {
            for (int i = 0; i < n6; ++i) {
                nodeArray[i + 1] = this.fullSeg(string, i);
            }
        }
        this.dumpDAG(nodeArray);
        boolean bl = false;
        n5 = 0;
        Node node3 = null;
        for (n4 = 0; n4 < nodeArray.length - 1; ++n4) {
            for (n3 = 0; n3 < nodeArray[n4].length; ++n3) {
                node3 = nodeArray[n4][n3];
                n5 = node3.getFollowing();
                for (n2 = 0; n2 < nodeArray[n5].length; ++n2) {
                    boolean bl2 = nodeArray[n5][n2].setPrevious(node3);
                    if (!bl2) continue;
                    bl = true;
                }
            }
        }
        if (!bl) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("\u6240\u6709\u5207\u5206\u7ed3\u679c\u90fd\u6ca1\u6709ngram\u5206\u503c\uff0c\u7b97\u6cd5\u9000\u5316\u4e3a \u6700\u5c11\u8bcd\u6570\u7b97\u6cd5");
            }
            for (n4 = 0; n4 < nodeArray.length; ++n4) {
                for (n3 = 0; n3 < nodeArray[n4].length; ++n3) {
                    nodeArray[n4][n3].setScore(null);
                }
            }
            node.score = Float.valueOf(1.0f);
            for (n4 = 0; n4 < nodeArray.length - 1; ++n4) {
                for (n3 = 0; n3 < nodeArray[n4].length; ++n3) {
                    node3 = nodeArray[n4][n3];
                    n5 = node3.getFollowing();
                    for (n2 = 0; n2 < nodeArray[n5].length; ++n2) {
                        nodeArray[n5][n2].setPrevious(node3, 1);
                    }
                }
            }
        }
        this.dumpShortestPath(nodeArray);
        return this.toWords(node2);
    }

    private List<Word> toWords(Node node) {
        Stack<String> stack = new Stack<String>();
        while ((node = node.getPrevious()) != null) {
            if ("S".equals(node.getText())) continue;
            stack.push(node.getText());
        }
        int n = stack.size();
        ArrayList<Word> arrayList = new ArrayList<Word>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Word((String)stack.pop()));
        }
        return arrayList;
    }

    private Node[] fullSeg(String string, int n) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.add(new Node(string.substring(n, n + 1), n + 1));
        int n2 = string.length();
        int n3 = n2 - n;
        int n4 = this.getInterceptLength();
        if (n3 > n4) {
            n3 = n4;
        }
        while (n3 > 1) {
            if (this.getDictionary().contains(string, n, n3) || RecognitionTool.recog(string, n, n3)) {
                linkedList.add(new Node(string.substring(n, n + n3), n + 1));
            }
            --n3;
        }
        return linkedList.toArray(new Node[0]);
    }

    private void dumpShortestPath(Node[][] nodeArray) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6709\u5411\u65e0\u73af\u56fe\u7684\u6700\u4f73\u8def\u5f84\uff1a");
            for (Node[] nodeArray2 : nodeArray) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Node node : nodeArray2) {
                    stringBuilder.append("\u3010").append(node.getText()).append("(").append(node.getScore()).append(")").append("<-").append(node.getPrevious() == null ? "" : node.getPrevious().getText()).append("\u3011\t");
                }
                this.LOGGER.debug(stringBuilder.toString());
            }
        }
    }

    private void dumpDAG(Node[][] nodeArray) {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6709\u5411\u65e0\u73af\u56fe\uff1a");
            for (int i = 0; i < nodeArray.length - 1; ++i) {
                Node[] nodeArray2 = nodeArray[i];
                StringBuilder stringBuilder = new StringBuilder();
                for (Node node : nodeArray2) {
                    int n = node.getFollowing();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (int j = 0; j < nodeArray[n].length; ++j) {
                        String string = nodeArray[n][j].getText();
                        stringBuilder2.append("(").append(string).append(")");
                    }
                    stringBuilder.append("\u3010").append(node.getText()).append("->").append(stringBuilder2.toString()).append("\u3011\t");
                }
                this.LOGGER.debug(stringBuilder.toString());
            }
        }
    }

    public static void main(String[] stringArray) {
        MaxNgramScore maxNgramScore = new MaxNgramScore();
        if (stringArray != null && stringArray.length > 0) {
            System.out.println(maxNgramScore.seg(Arrays.asList(stringArray).toString()));
            return;
        }
        System.out.println(maxNgramScore.seg("\u72ec\u7acb\u81ea\u4e3b\u548c\u5e73\u7b49\u4e92\u5229\u7684\u539f\u5219"));
        System.out.println(maxNgramScore.seg("\u6211\u7231\u6768\u5c1a\u5ddd"));
    }

    private static class Node {
        private String text;
        private Node previous;
        private int offset;
        private Float score;

        public Node(String string, int n) {
            this.text = string;
            this.offset = n;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public Float getScore() {
            return this.score;
        }

        public void setScore(Float f) {
            this.score = f;
        }

        public Node getPrevious() {
            return this.previous;
        }

        public boolean setPrevious(Node node) {
            float f = Bigram.getScore(node.getText(), this.getText());
            if (this.score == null) {
                this.score = Float.valueOf(node.score.floatValue() + f);
                this.previous = node;
            } else if (node.score.floatValue() + f > this.score.floatValue()) {
                this.score = Float.valueOf(node.score.floatValue() + f);
                this.previous = node;
            }
            return f > 0.0f;
        }

        public void setPrevious(Node node, int n) {
            if (this.score == null) {
                this.score = Float.valueOf(node.score.floatValue() + (float)n);
                this.previous = node;
            } else if (node.score.floatValue() + (float)n < this.score.floatValue()) {
                this.score = Float.valueOf(node.score.floatValue() + (float)n);
                this.previous = node;
            }
        }

        public int getFollowing() {
            return this.offset + this.text.length();
        }

        public String toString() {
            return "Node{text='" + this.text + '\'' + ", previous=" + this.previous + ", offset=" + this.offset + ", score=" + this.score + '}';
        }
    }
}

