/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.RowPartitionExtractor;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.IgniteUtils;

public class RehashingPartitionExtractor<RowT>
implements RowPartitionExtractor<RowT> {
    private final int targetCount;
    private final int[] fields;
    private final RowHandler<RowT> rowHandler;

    public RehashingPartitionExtractor(int targetCount, int[] fields, RowHandler<RowT> rowHandler) {
        assert (!ArrayUtils.nullOrEmpty(fields));
        this.targetCount = targetCount;
        this.fields = fields;
        this.rowHandler = rowHandler;
    }

    @Override
    public int partition(RowT row) {
        int hash = 0;
        for (int columnId : this.fields) {
            Object value = this.rowHandler.get(columnId, row);
            hash = 31 * hash + (value == null ? 0 : value.hashCode());
        }
        return IgniteUtils.safeAbs(hash) % this.targetCount;
    }
}

