/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.partitiondistribution.Assignment;
import org.apache.ignite3.internal.raft.Peer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class PeersAndLearners {
    @IgniteToStringInclude
    private final Set<Peer> peers;
    @IgniteToStringInclude
    private final Set<Peer> learners;

    private PeersAndLearners(Collection<Peer> peers, Collection<Peer> learners) {
        this.peers = Set.copyOf(peers);
        this.learners = Set.copyOf(learners);
    }

    public static PeersAndLearners fromConsistentIds(Set<String> peerNames) {
        return PeersAndLearners.fromConsistentIds(peerNames, Set.of());
    }

    public static PeersAndLearners fromConsistentIds(Set<String> peerNames, Set<String> learnerNames) {
        Set<Peer> peers = peerNames.stream().map(Peer::new).collect(Collectors.toUnmodifiableSet());
        Set<Peer> learners = learnerNames.stream().map(name -> {
            int idx = peerNames.contains(name) ? 1 : 0;
            return new Peer((String)name, idx);
        }).collect(Collectors.toUnmodifiableSet());
        return new PeersAndLearners(peers, learners);
    }

    public static PeersAndLearners fromPeers(Collection<Peer> peers, Collection<Peer> learners) {
        assert (Collections.disjoint(peers, learners));
        return new PeersAndLearners(peers, learners);
    }

    public static PeersAndLearners fromAssignments(Collection<Assignment> assignments) {
        HashSet<String> peers = new HashSet<String>();
        HashSet<String> learners = new HashSet<String>();
        for (Assignment assignment : assignments) {
            if (assignment.isPeer()) {
                peers.add(assignment.consistentId());
                continue;
            }
            learners.add(assignment.consistentId());
        }
        return PeersAndLearners.fromConsistentIds(peers, learners);
    }

    public Set<Peer> peers() {
        return this.peers;
    }

    public Set<Peer> learners() {
        return this.learners;
    }

    @Nullable
    public Peer peer(String consistentId) {
        return this.peers.stream().filter(p -> p.consistentId().equals(consistentId)).findAny().orElse(null);
    }

    @Nullable
    public Peer learner(String consistentId) {
        return this.learners.stream().filter(p -> p.consistentId().equals(consistentId)).findAny().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeersAndLearners that = (PeersAndLearners)o;
        if (!this.peers.equals(that.peers)) {
            return false;
        }
        return this.learners.equals(that.learners);
    }

    public int hashCode() {
        int result = this.peers.hashCode();
        result = 31 * result + this.learners.hashCode();
        return result;
    }

    public String toString() {
        return S.toString(PeersAndLearners.class, this);
    }
}

