/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.cluster.init;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.cluster.ClusterInitCall;
import org.apache.ignite.internal.cli.call.cluster.ClusterInitCallInput;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.cluster.init.ClusterInitOptions;
import org.apache.ignite.internal.cli.commands.cluster.init.ConfigAsPathException;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.flow.builder.FlowBuilder;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.internal.cli.core.style.component.QuestionUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElement;
import picocli.CommandLine;

@CommandLine.Command(name="init", description={"Initializes an Ignite cluster"})
public class ClusterInitReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private ClusterInitOptions clusterInitOptions;
    @Inject
    private ClusterInitCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).then(this.askQuestionIfConfigIsPath().build()).then(Flows.fromCall(this.call)).print());
    }

    private FlowBuilder<String, ClusterInitCallInput> askQuestionIfConfigIsPath() {
        try {
            this.clusterInitOptions.clusterConfiguration();
            return Flows.from(this::buildCallInput);
        }
        catch (ConfigAsPathException e) {
            QuestionUiComponent questionUiComponent = QuestionUiComponent.fromYesNoQuestion("It seems that you have passed the path to the configuration file in the configuration content --config option. Do you want to read cluster configuration from this file?", new UiElement[0]);
            return Flows.acceptQuestion(questionUiComponent, clusterUrl -> ClusterInitCallInput.builder().clusterConfiguration(this.clusterInitOptions.readConfigAsPath()).cmgNodes(this.clusterInitOptions.cmgNodes()).metaStorageNodes(this.clusterInitOptions.metaStorageNodes()).clusterName(this.clusterInitOptions.clusterName()).clusterUrl((String)clusterUrl).build());
        }
    }

    private ClusterInitCallInput buildCallInput(String clusterUrl) {
        return ClusterInitCallInput.builder().clusterUrl(clusterUrl).fromClusterInitOptions(this.clusterInitOptions).build();
    }
}

