/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.auth;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.util.LangUtils;

public final class AuthResult {
    private final boolean success;
    private final List<NameValuePair> params;

    public AuthResult(boolean success, List<NameValuePair> params) {
        this.success = success;
        this.params = params != null ? Collections.unmodifiableList(params) : Collections.emptyList();
    }

    public AuthResult(boolean success, NameValuePair ... params) {
        this(success, Arrays.asList(params));
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean hasParams() {
        return !this.params.isEmpty();
    }

    public List<NameValuePair> getParams() {
        return this.params;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode((int)hash, (boolean)this.success);
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AuthResult) {
            AuthResult that = (AuthResult)o;
            return this.success == that.success;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.success);
        if (!this.params.isEmpty()) {
            buf.append(" ").append(this.params);
        }
        return buf.toString();
    }
}

