/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationTargetException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStorePasswdAuthenticationProvider;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreCustomAuthenticationProviderImpl
implements MetaStorePasswdAuthenticationProvider {
    private final MetaStorePasswdAuthenticationProvider customProvider;
    protected static final Logger LOG = LoggerFactory.getLogger(MetaStoreCustomAuthenticationProviderImpl.class);

    MetaStoreCustomAuthenticationProviderImpl(Configuration conf) throws AuthenticationException {
        MetaStorePasswdAuthenticationProvider customProvider;
        Class<MetaStorePasswdAuthenticationProvider> customHandlerClass;
        String customProviderName = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.METASTORE_CUSTOM_AUTHENTICATION_CLASS);
        try {
            customHandlerClass = JavaUtils.getClass(customProviderName, MetaStorePasswdAuthenticationProvider.class);
        }
        catch (MetaException me) {
            throw new AuthenticationException(me.getMessage());
        }
        try {
            customProvider = customHandlerClass.getConstructor(Configuration.class).newInstance(conf);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            customProvider = (MetaStorePasswdAuthenticationProvider)ReflectionUtils.newInstance(customHandlerClass, (Configuration)conf);
        }
        this.customProvider = customProvider;
    }

    @Override
    public void authenticate(String user, String password) throws AuthenticationException {
        this.customProvider.authenticate(user, password);
    }
}

