/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.auth;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthSessionCache
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AuthSessionCache.class);
    private final Duration sessionTimeout;
    private final Executor executor;
    private final Ticker ticker;
    private volatile Cache<String, AuthSession> sessionCache;

    public AuthSessionCache(String name, Duration sessionTimeout) {
        this(sessionTimeout, ThreadPools.newExitingWorkerPool(name + "-auth-session-evict", 1), Ticker.systemTicker());
    }

    AuthSessionCache(Duration sessionTimeout, Executor executor, Ticker ticker) {
        this.sessionTimeout = sessionTimeout;
        this.executor = executor;
        this.ticker = ticker;
    }

    public <T extends AuthSession> T cachedSession(String key, Function<String, T> loader) {
        return (T)this.sessionCache().get(key, loader);
    }

    @Override
    public void close() {
        try {
            Cache<String, AuthSession> cache = this.sessionCache;
            this.sessionCache = null;
            if (cache != null) {
                cache.invalidateAll();
                cache.cleanUp();
            }
        }
        finally {
            if (this.executor instanceof ExecutorService) {
                ExecutorService service = (ExecutorService)this.executor;
                service.shutdown();
                if (!Uninterruptibles.awaitTerminationUninterruptibly(service, 10L, TimeUnit.SECONDS)) {
                    LOG.warn("Timed out waiting for eviction executor to terminate");
                }
                service.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Cache<String, AuthSession> sessionCache() {
        if (this.sessionCache == null) {
            AuthSessionCache authSessionCache = this;
            synchronized (authSessionCache) {
                if (this.sessionCache == null) {
                    this.sessionCache = this.newSessionCache();
                }
            }
        }
        return this.sessionCache;
    }

    private Cache<String, AuthSession> newSessionCache() {
        Caffeine<String, AuthSession> builder = Caffeine.newBuilder().executor(this.executor).expireAfterAccess(this.sessionTimeout).ticker(this.ticker).removalListener((id, auth, cause) -> {
            if (auth != null) {
                auth.close();
            }
        });
        return builder.build();
    }
}

