/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite.sql;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;

public class NonNativeAcidMultiInsertSqlGenerator
extends MultiInsertSqlGenerator {
    private final String deletePrefix;

    public NonNativeAcidMultiInsertSqlGenerator(Table table, String targetTableFullName, HiveConf conf, String subQueryAlias, String deletePrefix) {
        super(table, targetTableFullName, conf, subQueryAlias);
        this.deletePrefix = deletePrefix;
    }

    @Override
    public void appendAcidSelectColumns(Context.Operation operation) {
        this.appendAcidSelectColumns(operation, false, false);
    }

    @Override
    public void appendAcidSelectColumnsForDeletedRecords(Context.Operation operation, boolean skipPrefix) {
        this.appendAcidSelectColumns(operation, true, skipPrefix);
    }

    private void appendAcidSelectColumns(Context.Operation operation, boolean markRowIdAsDeleted, boolean skipPrefix) {
        List<FieldSchema> acidSelectColumns = this.targetTable.getStorageHandler().acidSelectColumns(this.targetTable, operation);
        for (FieldSchema fieldSchema : acidSelectColumns) {
            String identifier;
            boolean deletedRowId = markRowIdAsDeleted && fieldSchema.equals(this.targetTable.getStorageHandler().getRowId());
            String string = identifier = deletedRowId ? "-1" : HiveUtils.unparseIdentifier(fieldSchema.getName(), (Configuration)this.conf);
            if (!markRowIdAsDeleted || skipPrefix) {
                this.queryStr.append(identifier);
            }
            if (!(!StringUtils.isNotEmpty((CharSequence)this.deletePrefix) || markRowIdAsDeleted && skipPrefix)) {
                if (!markRowIdAsDeleted) {
                    this.queryStr.append(" AS ");
                }
                String prefixedIdentifier = deletedRowId ? "-1" : HiveUtils.unparseIdentifier(this.deletePrefix + fieldSchema.getName(), (Configuration)this.conf);
                this.queryStr.append(prefixedIdentifier);
            }
            this.queryStr.append(",");
        }
    }

    @Override
    public List<String> getDeleteValues(Context.Operation operation) {
        return this.targetTable.getStorageHandler().acidSelectColumns(this.targetTable, operation).stream().map(fieldSchema -> this.qualify(HiveUtils.unparseIdentifier(this.deletePrefix + fieldSchema.getName(), (Configuration)this.conf))).collect(Collectors.toList());
    }

    @Override
    public List<String> getSortKeys(Context.Operation operation) {
        return this.targetTable.getStorageHandler().acidSortColumns(this.targetTable, operation).stream().map(fieldSchema -> this.qualify(HiveUtils.unparseIdentifier(this.deletePrefix + fieldSchema.getName(), (Configuration)this.conf))).collect(Collectors.toList());
    }
}

