/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lock;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lock.CompileLock;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class CompileLockFactory {
    private static final ReentrantLock SERIALIZABLE_COMPILE_LOCK = new ReentrantLock(true);

    private CompileLockFactory() {
    }

    public static CompileLock newInstance(HiveConf conf, String command) {
        boolean isParallelEnabled;
        Lock underlying = SERIALIZABLE_COMPILE_LOCK;
        boolean bl = isParallelEnabled = conf != null && HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION);
        if (isParallelEnabled) {
            int compileQuota = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT);
            underlying = compileQuota > 0 ? SessionWithQuotaCompileLock.instance : SessionState.get().getCompileLock();
        }
        long timeout = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_COMPILE_LOCK_TIMEOUT, (TimeUnit)TimeUnit.SECONDS);
        return new CompileLock(underlying, timeout, command);
    }

    private static enum SessionWithQuotaCompileLock implements Lock
    {
        instance(SessionState.getSessionConf().getIntVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION_LIMIT));

        private final Semaphore globalCompileQuotas;

        private SessionWithQuotaCompileLock(int compilePoolSize) {
            this.globalCompileQuotas = new Semaphore(compilePoolSize, true);
        }

        @Override
        public void lock() {
            SessionState.get().getCompileLock().lock();
            this.globalCompileQuotas.acquireUninterruptibly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            boolean result = false;
            long startTime = System.nanoTime();
            ReentrantLock compileLock = SessionState.get().getCompileLock();
            try {
                result = compileLock.tryLock(time, unit) && this.globalCompileQuotas.tryAcquire(this.getRemainingTime(startTime, unit.toNanos(time)), TimeUnit.NANOSECONDS);
            }
            finally {
                if (!result && compileLock.isHeldByCurrentThread()) {
                    compileLock.unlock();
                }
            }
            return result;
        }

        @Override
        public void unlock() {
            SessionState.get().getCompileLock().unlock();
            this.globalCompileQuotas.release();
        }

        private long getRemainingTime(long startTime, long time) {
            long timeout = time - (System.nanoTime() - startTime);
            return timeout < 0L ? 0L : timeout;
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

