/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class TruncDateFromTimestamp
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final String fmt;

    public TruncDateFromTimestamp(int colNum, byte[] fmt, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.fmt = new String(fmt, StandardCharsets.UTF_8);
    }

    public TruncDateFromTimestamp() {
        this.fmt = "";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputColumnNum[0] + ", format " + this.fmt;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        ColumnVector inputColVector = batch.cols[this.inputColumnNum[0]];
        BytesColumnVector outputColVector = (BytesColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.truncDate(inputColVector, outputColVector, 0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.truncDate(inputColVector, outputColVector, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.truncDate(inputColVector, outputColVector, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.truncDate(inputColVector, outputColVector, i);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    this.truncDate(inputColVector, outputColVector, i);
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputColVector.isNull[i]) continue;
                    this.truncDate(inputColVector, outputColVector, i);
                }
            }
        }
    }

    protected void truncDate(ColumnVector inV, BytesColumnVector outV, int i) {
        Date date = Date.ofEpochMilli((long)((TimestampColumnVector)inV).getTime(i));
        this.processDate(outV, i, date);
    }

    protected void processDate(BytesColumnVector outV, int i, Date date) {
        switch (this.fmt) {
            case "YEAR": 
            case "YYYY": 
            case "YY": {
                date.setMonth(1);
            }
            case "MONTH": 
            case "MON": 
            case "MM": {
                date.setDayOfMonth(1);
                break;
            }
            case "QUARTER": 
            case "Q": {
                int month = date.getMonth() - 1;
                int quarter = month / 3;
                int monthToSet = quarter * 3 + 1;
                date.setMonth(monthToSet);
                date.setDayOfMonth(1);
                break;
            }
        }
        byte[] bytes = date.toString().getBytes(StandardCharsets.UTF_8);
        outV.setVal(i, bytes, 0, bytes.length);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(this.getInputColumnType(), VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }

    protected VectorExpressionDescriptor.ArgumentType getInputColumnType() {
        return VectorExpressionDescriptor.ArgumentType.TIMESTAMP;
    }
}

