/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.Serializable;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.util.LinkedList;
import java.util.List;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.AbstractServerSocket;

public abstract class AbstractSocketEntry
extends AbstractServerSocket<TcpAddress> {
    private static final LogAdapter logger = LogFactory.getLogger(AbstractSocketEntry.class);
    protected Socket socket;
    private volatile int registrations = 0;
    private final LinkedList<byte[]> messages = new LinkedList();
    private volatile int busyLoops = 0;

    public AbstractSocketEntry(TcpAddress address, Socket socket) {
        super(address);
        this.socket = socket;
    }

    public synchronized void addRegistration(Selector selector, int opKey) throws ClosedChannelException {
        if ((this.registrations & opKey) == 0) {
            this.registrations |= opKey;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Adding operation " + opKey + " for: " + this.toString())));
            }
            this.socket.getChannel().register(selector, this.registrations, this);
        } else if (!this.socket.getChannel().isRegistered()) {
            this.registrations = opKey;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Registering new operation " + opKey + " for: " + this.toString())));
            }
            this.socket.getChannel().register(selector, opKey, this);
        }
    }

    public synchronized void removeRegistration(Selector selector, int opKey) throws ClosedChannelException {
        if ((this.registrations & opKey) == opKey) {
            this.registrations &= ~opKey;
            this.socket.getChannel().register(selector, this.registrations, this);
        }
    }

    public synchronized boolean isRegistered(int opKey) {
        return (this.registrations & opKey) == opKey;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public LinkedList<byte[]> getMessages() {
        return this.messages;
    }

    public synchronized void addMessage(byte[] message) {
        this.messages.add(message);
    }

    public synchronized void insertMessages(List<byte[]> messages) {
        this.messages.addAll(0, messages);
    }

    public synchronized byte[] nextMessage() {
        if (this.messages.size() > 0) {
            return this.messages.removeFirst();
        }
        return null;
    }

    public synchronized boolean hasMessage() {
        return !this.messages.isEmpty();
    }

    public synchronized int nextBusyLoop() {
        return ++this.busyLoops;
    }

    public void resetBusyLoops() {
        this.busyLoops = 0;
    }

    public abstract String toString();
}

