/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.store;

import java.util.Comparator;
import org.apache.helix.store.PropertyJsonSerializer;
import org.apache.helix.store.PropertyStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyJsonComparator<T>
implements Comparator<T> {
    private static Logger LOG = LoggerFactory.getLogger(PropertyJsonComparator.class);
    private final PropertyJsonSerializer<T> _serializer;

    public PropertyJsonComparator(Class<T> clazz) {
        this._serializer = new PropertyJsonSerializer<T>(clazz);
    }

    @Override
    public int compare(T arg0, T arg1) {
        if (arg0 == null && arg1 == null) {
            return 0;
        }
        if (arg0 == null && arg1 != null) {
            return -1;
        }
        if (arg0 != null && arg1 == null) {
            return 1;
        }
        try {
            String s0 = new String(this._serializer.serialize(arg0));
            String s1 = new String(this._serializer.serialize(arg1));
            return s0.compareTo(s1);
        }
        catch (PropertyStoreException e) {
            LOG.warn(e.getMessage());
            return -1;
        }
    }
}

