/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.metadatastore;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.msdcommon.callback.RoutingDataListener;
import org.apache.helix.msdcommon.datamodel.MetadataStoreRoutingData;
import org.apache.helix.msdcommon.datamodel.TrieRoutingData;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.rest.metadatastore.MetadataStoreDirectory;
import org.apache.helix.rest.metadatastore.accessor.MetadataStoreRoutingDataReader;
import org.apache.helix.rest.metadatastore.accessor.MetadataStoreRoutingDataWriter;
import org.apache.helix.rest.metadatastore.accessor.ZkRoutingDataReader;
import org.apache.helix.rest.metadatastore.accessor.ZkRoutingDataWriter;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.zkclient.exception.ZkNodeExistsException;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkMetadataStoreDirectory
implements MetadataStoreDirectory,
RoutingDataListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZkMetadataStoreDirectory.class);
    protected final Map<String, MetadataStoreRoutingDataReader> _routingDataReaderMap = new ConcurrentHashMap<String, MetadataStoreRoutingDataReader>();
    protected final Map<String, MetadataStoreRoutingDataWriter> _routingDataWriterMap = new ConcurrentHashMap<String, MetadataStoreRoutingDataWriter>();
    protected final Map<String, MetadataStoreRoutingData> _routingDataMap;
    protected final Map<String, String> _routingZkAddressMap = new ConcurrentHashMap<String, String>();
    protected final Map<String, Map<String, List<String>>> _realmToShardingKeysMap = new ConcurrentHashMap<String, Map<String, List<String>>>();
    private static volatile ZkMetadataStoreDirectory _zkMetadataStoreDirectoryInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZkMetadataStoreDirectory getInstance() {
        if (_zkMetadataStoreDirectoryInstance != null) return _zkMetadataStoreDirectoryInstance;
        Class<ZkMetadataStoreDirectory> clazz = ZkMetadataStoreDirectory.class;
        synchronized (ZkMetadataStoreDirectory.class) {
            if (_zkMetadataStoreDirectoryInstance != null) return _zkMetadataStoreDirectoryInstance;
            _zkMetadataStoreDirectoryInstance = new ZkMetadataStoreDirectory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _zkMetadataStoreDirectoryInstance;
        }
    }

    public static ZkMetadataStoreDirectory getInstance(String namespace, String zkAddress) throws InvalidRoutingDataException {
        ZkMetadataStoreDirectory.getInstance().init(namespace, zkAddress);
        return _zkMetadataStoreDirectoryInstance;
    }

    @VisibleForTesting
    protected ZkMetadataStoreDirectory() {
        this._routingDataMap = new ConcurrentHashMap<String, MetadataStoreRoutingData>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String namespace, String zkAddress) throws InvalidRoutingDataException {
        if (!this._routingZkAddressMap.containsKey(namespace)) {
            Map<String, String> map = this._routingZkAddressMap;
            synchronized (map) {
                if (!this._routingZkAddressMap.containsKey(namespace)) {
                    HelixZkClient zkClient = null;
                    try {
                        zkClient = DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress), new HelixZkClient.ZkClientConfig().setZkSerializer((ZkSerializer)new ZNRecordSerializer()));
                        ZkMetadataStoreDirectory.createRoutingDataPath(zkClient, zkAddress);
                    }
                    finally {
                        if (zkClient != null && !zkClient.isClosed()) {
                            zkClient.close();
                        }
                    }
                    try {
                        this._routingZkAddressMap.put(namespace, zkAddress);
                        this._routingDataReaderMap.put(namespace, new ZkRoutingDataReader(namespace, zkAddress, this));
                        this._routingDataWriterMap.put(namespace, new ZkRoutingDataWriter(namespace, zkAddress));
                    }
                    catch (IllegalArgumentException | IllegalStateException e) {
                        LOG.error("ZkMetadataStoreDirectory: initializing ZkRoutingDataReader/Writer failed!", (Throwable)e);
                    }
                    Map<String, List<String>> rawRoutingData = this._routingDataReaderMap.get(namespace).getRoutingData();
                    this._realmToShardingKeysMap.put(namespace, rawRoutingData);
                    try {
                        this._routingDataMap.put(namespace, (MetadataStoreRoutingData)new TrieRoutingData(rawRoutingData));
                    }
                    catch (InvalidRoutingDataException e) {
                        LOG.warn("ZkMetadataStoreDirectory: TrieRoutingData is not created for namespace {}", (Object)namespace, (Object)e);
                    }
                }
            }
        }
    }

    @Override
    public Collection<String> getAllNamespaces() {
        return Collections.unmodifiableCollection(this._routingZkAddressMap.keySet());
    }

    @Override
    public Collection<String> getAllMetadataStoreRealms(String namespace) {
        if (!this._realmToShardingKeysMap.containsKey(namespace)) {
            throw new NoSuchElementException("Namespace " + namespace + " does not exist!");
        }
        return Collections.unmodifiableCollection(this._realmToShardingKeysMap.get(namespace).keySet());
    }

    @Override
    public Collection<String> getAllShardingKeys(String namespace) {
        if (!this._realmToShardingKeysMap.containsKey(namespace)) {
            throw new NoSuchElementException("Namespace " + namespace + " does not exist!");
        }
        HashSet<String> allShardingKeys = new HashSet<String>();
        this._realmToShardingKeysMap.get(namespace).values().forEach(allShardingKeys::addAll);
        return allShardingKeys;
    }

    @Override
    public Map<String, List<String>> getNamespaceRoutingData(String namespace) {
        Map<String, List<String>> routingData = this._realmToShardingKeysMap.get(namespace);
        if (routingData == null) {
            throw new NoSuchElementException("Namespace " + namespace + " does not exist!");
        }
        return routingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setNamespaceRoutingData(String namespace, Map<String, List<String>> routingData) {
        if (!this._routingDataWriterMap.containsKey(namespace)) {
            throw new IllegalArgumentException("Failed to set routing data: Namespace " + namespace + " is not found!");
        }
        ZkMetadataStoreDirectory zkMetadataStoreDirectory = this;
        synchronized (zkMetadataStoreDirectory) {
            if (!this._routingDataWriterMap.get(namespace).setRoutingData(routingData)) {
                return false;
            }
            this.refreshRoutingData(namespace);
            return true;
        }
    }

    @Override
    public Collection<String> getAllShardingKeysInRealm(String namespace, String realm) {
        if (!this._realmToShardingKeysMap.containsKey(namespace)) {
            throw new NoSuchElementException("Namespace " + namespace + " does not exist!");
        }
        if (!this._realmToShardingKeysMap.get(namespace).containsKey(realm)) {
            throw new NoSuchElementException("Realm " + realm + " does not exist in namespace " + namespace);
        }
        return Collections.unmodifiableCollection((Collection)this._realmToShardingKeysMap.get(namespace).get(realm));
    }

    @Override
    public Map<String, String> getAllMappingUnderPath(String namespace, String path) {
        if (!this._routingZkAddressMap.containsKey(namespace)) {
            throw new NoSuchElementException("Failed to get all mapping under path: Namespace " + namespace + " is not found!");
        }
        if (!this._routingDataMap.containsKey(namespace)) {
            throw new IllegalStateException("Failed to get all mapping under path: Namespace " + namespace + " contains either empty or invalid routing data!");
        }
        return this._routingDataMap.get(namespace).getAllMappingUnderPath(path);
    }

    @Override
    public String getMetadataStoreRealm(String namespace, String shardingKey) {
        if (!this._routingZkAddressMap.containsKey(namespace)) {
            throw new NoSuchElementException("Failed to get metadata store realm: Namespace " + namespace + " is not found!");
        }
        if (!this._routingDataMap.containsKey(namespace)) {
            throw new IllegalStateException("Failed to get metadata store realm: Namespace " + namespace + " contains either empty or invalid routing data!");
        }
        return this._routingDataMap.get(namespace).getMetadataStoreRealm(shardingKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addMetadataStoreRealm(String namespace, String realm) {
        if (!this._routingDataWriterMap.containsKey(namespace)) {
            throw new NoSuchElementException("Failed to add metadata store realm: Namespace " + namespace + " is not found!");
        }
        ZkMetadataStoreDirectory zkMetadataStoreDirectory = this;
        synchronized (zkMetadataStoreDirectory) {
            if (!this._routingDataWriterMap.get(namespace).addMetadataStoreRealm(realm)) {
                return false;
            }
            this.refreshRoutingData(namespace);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMetadataStoreRealm(String namespace, String realm) {
        if (!this._routingDataWriterMap.containsKey(namespace)) {
            throw new NoSuchElementException("Failed to delete metadata store realm: Namespace " + namespace + " is not found!");
        }
        ZkMetadataStoreDirectory zkMetadataStoreDirectory = this;
        synchronized (zkMetadataStoreDirectory) {
            if (!this._routingDataWriterMap.get(namespace).deleteMetadataStoreRealm(realm)) {
                return false;
            }
            this.refreshRoutingData(namespace);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addShardingKey(String namespace, String realm, String shardingKey) {
        if (!this._routingDataWriterMap.containsKey(namespace)) {
            throw new NoSuchElementException("Failed to add sharding key: Namespace " + namespace + " is not found!");
        }
        ZkMetadataStoreDirectory zkMetadataStoreDirectory = this;
        synchronized (zkMetadataStoreDirectory) {
            if (this._routingDataMap.containsKey(namespace) && this._routingDataMap.get(namespace).containsKeyRealmPair(shardingKey, realm)) {
                return true;
            }
            if (this._routingDataMap.containsKey(namespace) && !this._routingDataMap.get(namespace).isShardingKeyInsertionValid(shardingKey)) {
                throw new IllegalArgumentException("Failed to add sharding key: Adding sharding key " + shardingKey + " makes routing data invalid!");
            }
            if (!this._routingDataWriterMap.get(namespace).addShardingKey(realm, shardingKey)) {
                return false;
            }
            this.refreshRoutingData(namespace);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteShardingKey(String namespace, String realm, String shardingKey) {
        if (!this._routingDataWriterMap.containsKey(namespace)) {
            throw new NoSuchElementException("Failed to delete sharding key: Namespace " + namespace + " is not found!");
        }
        ZkMetadataStoreDirectory zkMetadataStoreDirectory = this;
        synchronized (zkMetadataStoreDirectory) {
            if (!this._routingDataWriterMap.get(namespace).deleteShardingKey(realm, shardingKey)) {
                return false;
            }
            this.refreshRoutingData(namespace);
            return true;
        }
    }

    public void refreshRoutingData(String namespace) {
        TrieRoutingData trieRoutingData;
        Map<String, List<String>> rawRoutingData;
        if (!this._routingZkAddressMap.containsKey(namespace)) {
            LOG.error("Failed to refresh internally-cached routing data! Namespace not found: " + namespace);
            return;
        }
        try {
            rawRoutingData = this._routingDataReaderMap.get(namespace).getRoutingData();
        }
        catch (InvalidRoutingDataException e) {
            LOG.error("Failed to refresh cached routing data for namespace {}", (Object)namespace, (Object)e);
            this._realmToShardingKeysMap.put(namespace, Collections.emptyMap());
            this._routingDataMap.remove(namespace);
            return;
        }
        this._realmToShardingKeysMap.put(namespace, rawRoutingData);
        try {
            trieRoutingData = new TrieRoutingData(rawRoutingData);
        }
        catch (InvalidRoutingDataException e) {
            LOG.warn("TrieRoutingData is not created for namespace {}", (Object)namespace, (Object)e);
            this._routingDataMap.remove(namespace);
            return;
        }
        this._routingDataMap.put(namespace, (MetadataStoreRoutingData)trieRoutingData);
    }

    @Override
    public synchronized void close() {
        this._routingDataReaderMap.values().forEach(MetadataStoreRoutingDataReader::close);
        this._routingDataWriterMap.values().forEach(MetadataStoreRoutingDataWriter::close);
        this._routingDataReaderMap.clear();
        this._routingDataWriterMap.clear();
        this._routingZkAddressMap.clear();
        this._realmToShardingKeysMap.clear();
        this._routingDataMap.clear();
        _zkMetadataStoreDirectoryInstance = null;
    }

    public static void createRoutingDataPath(HelixZkClient zkClient, String zkAddress) {
        try {
            zkClient.createPersistent("/METADATA_STORE_ROUTING_DATA", true);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            // empty catch block
        }
        ZNRecord znRecord = new ZNRecord("/METADATA_STORE_ROUTING_DATA".substring(1));
        znRecord.setListField("ROUTING_ZK_ADDRESS", Collections.singletonList(zkAddress));
        zkClient.writeData("/METADATA_STORE_ROUTING_DATA", (Object)znRecord);
    }
}

