/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationStatusSourceStartedTargetStoppedNoOps
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationStatusSourceStartedTargetStoppedNoOps.class);

    @Test
    public void testReplicationStatusSourceStartedTargetStoppedNoOps() throws Exception {
        UTIL2.shutdownMiniHBaseCluster();
        TestReplicationStatusSourceStartedTargetStoppedNoOps.restartSourceCluster(1);
        Admin hbaseAdmin = UTIL1.getAdmin();
        ServerName serverName = UTIL1.getHBaseCluster().getRegionServer(0).getServerName();
        Thread.sleep(10000L);
        ClusterMetrics metrics = hbaseAdmin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
        List loadSources = ((ServerMetrics)metrics.getLiveServerMetrics().get(serverName)).getReplicationLoadSourceList();
        Assert.assertEquals((long)1L, (long)loadSources.size());
        ReplicationLoadSource loadSource = (ReplicationLoadSource)loadSources.get(0);
        Assert.assertFalse((boolean)loadSource.hasEditsSinceRestart());
        Assert.assertEquals((long)0L, (long)loadSource.getTimestampOfLastShippedOp());
        Assert.assertEquals((long)0L, (long)loadSource.getReplicationLag());
        Assert.assertFalse((boolean)loadSource.isRecovered());
    }
}

