/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hbase.hbck1.HBaseFsck;

public class ReplicationFsck
implements Closeable {
    private final Configuration configuration;

    ReplicationFsck(Configuration conf) {
        this.configuration = conf;
    }

    @Override
    public void close() {
    }

    int fsck(List<String> tables, boolean fix) throws IOException {
        try (HBaseFsck hbaseFsck = new HBaseFsck(this.configuration);){
            hbaseFsck.connect();
            hbaseFsck.setFixReplication(fix);
            hbaseFsck.checkAndFixReplication();
            if (tables != null && !tables.isEmpty()) {
                hbaseFsck.setCleanReplicationBarrier(fix);
                for (String table : tables) {
                    hbaseFsck.setCleanReplicationBarrierTable(table);
                    hbaseFsck.cleanReplicationBarrier();
                }
            }
        }
        catch (ClassNotFoundException | ReplicationException e) {
            throw new IOException(e);
        }
        return 0;
    }
}

