/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestReplicationEditsDroppedWithDroppedTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationEditsDroppedWithDroppedTable.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationEditsDroppedWithDroppedTable.class);
    private static Configuration conf1 = HBaseConfiguration.create();
    private static Configuration conf2 = HBaseConfiguration.create();
    protected static HBaseTestingUtility utility1;
    protected static HBaseTestingUtility utility2;
    private static Admin admin1;
    private static Admin admin2;
    private static final String namespace = "NS";
    private static final TableName NORMAL_TABLE;
    private static final TableName DROPPED_TABLE;
    private static final TableName DROPPED_NS_TABLE;
    private static final byte[] ROW;
    private static final byte[] FAMILY;
    private static final byte[] QUALIFIER;
    private static final byte[] VALUE;
    private static final String PEER_ID = "1";
    private static final long SLEEP_TIME = 1000L;
    private static final int NB_RETRIES = 10;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1.setBoolean("hbase.replication.drop.on.deleted.table", true);
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("replication.source.nb.capacity", 1);
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        conf1 = utility1.getConfiguration();
        conf2 = HBaseConfiguration.create((Configuration)conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        utility1.startMiniCluster(1);
        utility2.startMiniCluster(1);
        admin1 = utility1.getAdmin();
        admin2 = utility2.getAdmin();
        NamespaceDescriptor nsDesc = NamespaceDescriptor.create((String)namespace).build();
        admin1.createNamespace(nsDesc);
        admin2.createNamespace(nsDesc);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        for (JVMClusterUtil.RegionServerThread r : utility1.getHBaseCluster().getRegionServerThreads()) {
            utility1.getAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(utility2.getClusterKey()).setReplicateAllUserTables(true).build();
        admin1.addReplicationPeer(PEER_ID, rpc);
        this.createTable(NORMAL_TABLE);
    }

    @After
    public void tearDown() throws Exception {
        admin1.removeReplicationPeer(PEER_ID);
        admin1.disableTable(NORMAL_TABLE);
        admin1.deleteTable(NORMAL_TABLE);
        admin2.disableTable(NORMAL_TABLE);
        admin2.deleteTable(NORMAL_TABLE);
    }

    private void createTable(TableName tableName) throws Exception {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setScope(1).build()).build();
        admin1.createTable(desc);
        admin2.createTable(desc);
        utility1.waitUntilAllRegionsAssigned(tableName);
        utility2.waitUntilAllRegionsAssigned(tableName);
    }

    @Test
    public void testEditsDroppedWithDroppedTable() throws Exception {
        this.testWithDroppedTable(DROPPED_TABLE);
    }

    @Test
    public void testEditsDroppedWithDroppedTableNS() throws Exception {
        this.testWithDroppedTable(DROPPED_NS_TABLE);
    }

    private void testWithDroppedTable(TableName droppedTableName) throws Exception {
        this.createTable(droppedTableName);
        admin1.disableReplicationPeer(PEER_ID);
        try (Table droppedTable = utility1.getConnection().getTable(droppedTableName);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            droppedTable.put(put);
        }
        admin1.disableTable(droppedTableName);
        admin1.deleteTable(droppedTableName);
        admin2.disableTable(droppedTableName);
        admin2.deleteTable(droppedTableName);
        admin1.enableReplicationPeer(PEER_ID);
        this.verifyReplicationProceeded();
    }

    @Test
    public void testEditsBehindDroppedTableTiming() throws Exception {
        this.createTable(DROPPED_TABLE);
        admin1.disableReplicationPeer(PEER_ID);
        try (Table droppedTable = utility1.getConnection().getTable(DROPPED_TABLE);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            droppedTable.put(put);
        }
        admin2.disableTable(DROPPED_TABLE);
        admin2.deleteTable(DROPPED_TABLE);
        admin1.enableReplicationPeer(PEER_ID);
        this.verifyReplicationStuck();
        admin1.disableTable(DROPPED_TABLE);
        this.verifyReplicationStuck();
        admin1.deleteTable(DROPPED_TABLE);
        this.verifyReplicationProceeded();
    }

    private void verifyReplicationProceeded() throws Exception {
        try (Table normalTable = utility1.getConnection().getTable(NORMAL_TABLE);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            normalTable.put(put);
        }
        utility2.waitFor(10000L, () -> {
            try (Table normalTable = utility2.getConnection().getTable(NORMAL_TABLE);){
                Result result = normalTable.get(new Get(ROW).addColumn(FAMILY, QUALIFIER));
                boolean bl = result != null && !result.isEmpty() && Bytes.equals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER));
                return bl;
            }
        });
    }

    private void verifyReplicationStuck() throws Exception {
        try (Table normalTable = utility1.getConnection().getTable(NORMAL_TABLE);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            normalTable.put(put);
        }
        normalTable = utility2.getConnection().getTable(NORMAL_TABLE);
        var2_2 = null;
        try {
            for (int i = 0; i < 10; ++i) {
                Result result = normalTable.get(new Get(ROW).addColumn(FAMILY, QUALIFIER));
                if (result != null && !result.isEmpty()) {
                    Assert.fail((String)("Edit should have been stuck behind dropped tables, but value is " + Bytes.toString((byte[])result.getValue(FAMILY, QUALIFIER))));
                    continue;
                }
                LOG.info("Row not replicated, let's wait a bit more...");
                Thread.sleep(1000L);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (normalTable != null) {
                if (var2_2 != null) {
                    try {
                        normalTable.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    normalTable.close();
                }
            }
        }
    }

    static {
        NORMAL_TABLE = TableName.valueOf((String)"normal-table");
        DROPPED_TABLE = TableName.valueOf((String)"dropped-table");
        DROPPED_NS_TABLE = TableName.valueOf((String)"NS:dropped-table");
        ROW = Bytes.toBytes((String)"row");
        FAMILY = Bytes.toBytes((String)"f");
        QUALIFIER = Bytes.toBytes((String)"q");
        VALUE = Bytes.toBytes((String)"value");
    }
}

