/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.SimpleByteBufAllocator;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={RPCTests.class, MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestNettyRpcServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyRpcServer.class);
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final int NUM_ROWS = 100;
    private static final int MIN_LEN = 1000;
    private static final int MAX_LEN = 1000000;
    protected static final LoadTestKVGenerator GENERATOR = new LoadTestKVGenerator(1000, 1000000);
    protected static HBaseTestingUtility TEST_UTIL;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();
    @Parameterized.Parameter
    public String allocatorType;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"pooled"}, {"unpooled"}, {"heap"}, {SimpleByteBufAllocator.class.getName()});
    }

    @Before
    public void setup() throws Exception {
        if (TEST_UTIL == null) {
            TEST_UTIL = new HBaseTestingUtility();
        }
        TEST_UTIL.getConfiguration().set("hbase.rpc.server.impl", NettyRpcServer.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.netty.rpcserver.allocator", this.allocatorType);
        TEST_UTIL.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testNettyRpcServer() throws Exception {
        this.doTest(this.name.getTableName());
    }

    protected void doTest(TableName tableName) throws Exception {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setRegionSplitPolicyClassName(DisabledRegionSplitPolicy.class.getName()).build();
        try (Table table = TEST_UTIL.createTable(desc, (byte[][])new byte[][]{FAMILY}, TEST_UTIL.getConfiguration());){
            byte[] rowKey;
            int i;
            for (i = 0; i < 100; ++i) {
                rowKey = Bytes.toBytes((String)LoadTestKVGenerator.md5PrefixedKey((long)i));
                byte[] v = GENERATOR.generateRandomSizeValue((byte[][])new byte[][]{rowKey, QUALIFIER});
                table.put(new Put(rowKey).addColumn(FAMILY, QUALIFIER, v));
            }
            for (i = 0; i < 100; ++i) {
                rowKey = Bytes.toBytes((String)LoadTestKVGenerator.md5PrefixedKey((long)i));
                Result r = table.get(new Get(rowKey).addColumn(FAMILY, QUALIFIER));
                Assert.assertNotNull((String)"Result was empty", (Object)r);
                byte[] v = r.getValue(FAMILY, QUALIFIER);
                Assert.assertNotNull((String)"Result did not contain expected value", (Object)v);
                Assert.assertTrue((String)"Value was not verified", (boolean)LoadTestKVGenerator.verify((byte[])v, (byte[][])new byte[][]{rowKey, QUALIFIER}));
            }
        }
    }
}

