/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class S3xLoginHelper {
    public static final String LOGIN_WARNING = "The Filesystem URI contains login details. This authentication mechanism is no longer supported.";

    private S3xLoginHelper() {
    }

    public static URI buildFSURI(URI uri) {
        S3xLoginHelper.rejectSecretsInURIs(uri);
        Objects.requireNonNull(uri, "null uri");
        Objects.requireNonNull(uri.getScheme(), "null uri.getScheme()");
        if (uri.getHost() == null && uri.getAuthority() != null) {
            Objects.requireNonNull(uri.getHost(), "null uri host.");
        }
        Objects.requireNonNull(uri.getHost(), "null uri host.");
        return URI.create(uri.getScheme() + "://" + uri.getHost());
    }

    public static String toString(URI pathUri) {
        return pathUri != null ? String.format("%s://%s/%s", pathUri.getScheme(), pathUri.getHost(), pathUri.getPath()) : "(null URI)";
    }

    public static void rejectSecretsInURIs(URI name) {
        Login login = S3xLoginHelper.extractLoginDetails(name);
        Preconditions.checkArgument((!login.hasLogin() ? 1 : 0) != 0, (Object)LOGIN_WARNING);
    }

    @VisibleForTesting
    static Login extractLoginDetails(URI name) {
        if (name == null) {
            return Login.EMPTY;
        }
        String authority = name.getAuthority();
        if (authority == null) {
            return Login.EMPTY;
        }
        int loginIndex = authority.indexOf(64);
        if (loginIndex < 0) {
            return Login.EMPTY;
        }
        String login = authority.substring(0, loginIndex);
        int loginSplit = login.indexOf(58);
        if (loginSplit > 0) {
            String user = login.substring(0, loginSplit);
            String encodedPassword = login.substring(loginSplit + 1);
            return new Login(user, encodedPassword.isEmpty() ? "" : "password removed");
        }
        if (loginSplit == 0) {
            return Login.EMPTY;
        }
        return new Login(login, "");
    }

    public static URI canonicalizeUri(URI uri, int defaultPort) {
        if (uri.getPort() == -1 && defaultPort > 0) {
            try {
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), defaultPort, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)("Valid URI became unparseable: " + uri));
            }
        }
        return uri;
    }

    public static void checkPath(Configuration conf, URI fsUri, Path path, int defaultPort) {
        URI pathUri = path.toUri();
        String thatScheme = pathUri.getScheme();
        if (thatScheme == null) {
            return;
        }
        URI thisUri = S3xLoginHelper.canonicalizeUri(fsUri, defaultPort);
        String thisScheme = thisUri.getScheme();
        if (StringUtils.equalsIgnoreCase((CharSequence)thisScheme, (CharSequence)thatScheme)) {
            String thisHost = thisUri.getHost();
            String thatHost = pathUri.getHost();
            if (thatHost == null && thisHost != null) {
                URI defaultUri = FileSystem.getDefaultUri((Configuration)conf);
                pathUri = StringUtils.equalsIgnoreCase((CharSequence)thisScheme, (CharSequence)defaultUri.getScheme()) ? defaultUri : null;
            }
            if (pathUri != null && (thisHost == (thatHost = (pathUri = S3xLoginHelper.canonicalizeUri(pathUri, defaultPort)).getHost()) || thisHost != null && StringUtils.equalsIgnoreCase((CharSequence)thisHost, (CharSequence)thatHost))) {
                return;
            }
        }
        throw new IllegalArgumentException("Wrong FS " + S3xLoginHelper.toString(pathUri) + " -expected " + fsUri);
    }

    public static class Login {
        private final String user;
        private final String password;
        public static final Login EMPTY = new Login();

        public Login() {
            this("", "");
        }

        public Login(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public boolean hasLogin() {
            return StringUtils.isNotEmpty((CharSequence)this.password) || StringUtils.isNotEmpty((CharSequence)this.user);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Login that = (Login)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password);
        }

        public int hashCode() {
            return Objects.hash(this.user, this.password);
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

