/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.impl.ClientManager;
import org.apache.hadoop.fs.statistics.DurationTrackerFactory;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.apache.hadoop.util.functional.FutureIO;
import org.apache.hadoop.util.functional.LazyAutoCloseableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

public class ClientManagerImpl
implements ClientManager {
    public static final Logger LOG = LoggerFactory.getLogger(ClientManagerImpl.class);
    private final S3ClientFactory clientFactory;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final S3ClientFactory.S3ClientCreationParameters clientCreationParameters;
    private final DurationTrackerFactory durationTrackerFactory;
    private final LazyAutoCloseableReference<S3Client> s3Client;
    private final LazyAutoCloseableReference<S3AsyncClient> s3AsyncClient;
    private final LazyAutoCloseableReference<S3TransferManager> transferManager;

    public ClientManagerImpl(S3ClientFactory clientFactory, S3ClientFactory.S3ClientCreationParameters clientCreationParameters, DurationTrackerFactory durationTrackerFactory) {
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.clientCreationParameters = Objects.requireNonNull(clientCreationParameters);
        this.durationTrackerFactory = Objects.requireNonNull(durationTrackerFactory);
        this.s3Client = new LazyAutoCloseableReference(this.createS3Client());
        this.s3AsyncClient = new LazyAutoCloseableReference(this.createAyncClient());
        this.transferManager = new LazyAutoCloseableReference(this.createTransferManager());
    }

    private CallableRaisingIOE<S3Client> createS3Client() {
        return IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.durationTrackerFactory, (String)Statistic.STORE_CLIENT_CREATION.getSymbol(), () -> this.clientFactory.createS3Client(this.getUri(), this.clientCreationParameters));
    }

    private CallableRaisingIOE<S3AsyncClient> createAyncClient() {
        return IOStatisticsBinding.trackDurationOfOperation((DurationTrackerFactory)this.durationTrackerFactory, (String)Statistic.STORE_CLIENT_CREATION.getSymbol(), () -> this.clientFactory.createS3AsyncClient(this.getUri(), this.clientCreationParameters));
    }

    private CallableRaisingIOE<S3TransferManager> createTransferManager() {
        return () -> {
            S3AsyncClient asyncClient = (S3AsyncClient)this.s3AsyncClient.eval();
            return (S3TransferManager)IOStatisticsBinding.trackDuration((DurationTrackerFactory)this.durationTrackerFactory, (String)Statistic.STORE_CLIENT_CREATION.getSymbol(), () -> this.clientFactory.createS3TransferManager(asyncClient));
        };
    }

    @Override
    public synchronized S3Client getOrCreateS3Client() throws IOException {
        this.checkNotClosed();
        return (S3Client)this.s3Client.eval();
    }

    @Override
    public synchronized S3Client getOrCreateS3ClientUnchecked() throws UncheckedIOException {
        this.checkNotClosed();
        return (S3Client)this.s3Client.get();
    }

    @Override
    public synchronized S3AsyncClient getOrCreateAsyncClient() throws IOException {
        this.checkNotClosed();
        return (S3AsyncClient)this.s3AsyncClient.eval();
    }

    @Override
    public synchronized S3Client getOrCreateAsyncS3ClientUnchecked() throws UncheckedIOException {
        this.checkNotClosed();
        return (S3Client)this.s3Client.get();
    }

    @Override
    public synchronized S3TransferManager getOrCreateTransferManager() throws IOException {
        this.checkNotClosed();
        return (S3TransferManager)this.transferManager.eval();
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"Client manager is closed");
    }

    @Override
    public synchronized void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        ArrayList<CompletableFuture<Object>> l = new ArrayList<CompletableFuture<Object>>();
        l.add(this.closeAsync(this.transferManager));
        l.add(this.closeAsync(this.s3AsyncClient));
        l.add(this.closeAsync(this.s3Client));
        try {
            FutureIO.awaitAllFutures(l);
        }
        catch (Exception e) {
            LOG.warn("Exception in close", (Throwable)e);
        }
    }

    public URI getUri() {
        return this.clientCreationParameters.getPathUri();
    }

    private <T extends AutoCloseable> CompletableFuture<Object> closeAsync(LazyAutoCloseableReference<T> reference) {
        if (!reference.isSet()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                reference.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close {}", (Object)reference, (Object)e);
            }
            return null;
        });
    }

    public String toString() {
        return "ClientManagerImpl{closed=" + this.closed.get() + ", s3Client=" + this.s3Client + ", s3AsyncClient=" + this.s3AsyncClient + ", transferManager=" + this.transferManager + '}';
    }
}

