/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.applications.mawo.server.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.applications.mawo.server.common.Task;
import org.apache.hadoop.applications.mawo.server.common.TaskId;
import org.apache.hadoop.applications.mawo.server.common.TaskType;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask
implements Task {
    private TaskId taskID = new TaskId();
    private Map<String, String> environment = new HashMap<String, String>();
    private String taskCmd;
    private TaskType taskType;
    private long timeout;
    static final Logger LOG = LoggerFactory.getLogger(AbstractTask.class);

    public AbstractTask() {
    }

    public AbstractTask(TaskId taskId, Map<String, String> localenvironment, String taskCMD, long localtimeout) {
        this();
        this.setTaskId(taskId);
        this.setEnvironment(localenvironment);
        this.setTaskCmd(taskCMD);
        this.setTimeout(localtimeout);
        LOG.info("Created Task - type: " + (Object)((Object)this.taskType) + ", TaskId: " + this.taskID.toString() + ", cmd: '" + taskCMD + "' Timeout: " + this.timeout);
    }

    @Override
    public final Map<String, String> getEnvironment() {
        return this.environment;
    }

    @Override
    public final void setEnvironment(Map<String, String> localenvironment) {
        this.environment = localenvironment;
    }

    @Override
    public final String getTaskCmd() {
        return this.taskCmd;
    }

    @Override
    public final void setTaskCmd(String taskCMD) {
        this.taskCmd = taskCMD;
    }

    @Override
    public final TaskId getTaskId() {
        return this.taskID;
    }

    @Override
    public final void setTaskId(TaskId taskId) {
        if (taskId != null) {
            this.taskID = taskId;
        }
    }

    @Override
    public final TaskType getTaskType() {
        return this.taskType;
    }

    public final void setTaskType(TaskType type) {
        this.taskType = type;
    }

    @Override
    public final long getTimeout() {
        return this.timeout;
    }

    @Override
    public final void setTimeout(long taskTimeout) {
        this.timeout = taskTimeout;
    }

    public final void write(DataOutput out) throws IOException {
        this.taskID.write(out);
        int environmentSize = 0;
        environmentSize = this.environment == null ? 0 : this.environment.size();
        new IntWritable(environmentSize).write(out);
        if (environmentSize != 0) {
            for (Map.Entry<String, String> envEntry : this.environment.entrySet()) {
                new Text(envEntry.getKey()).write(out);
                new Text(envEntry.getValue()).write(out);
            }
        }
        Text taskCmdText = this.taskCmd == null ? new Text("") : new Text(this.taskCmd);
        taskCmdText.write(out);
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.taskType);
        WritableUtils.writeVLong((DataOutput)out, (long)this.timeout);
    }

    public final void readFields(DataInput in) throws IOException {
        this.taskID = new TaskId();
        this.taskID.readFields(in);
        IntWritable envSize = new IntWritable(0);
        envSize.readFields(in);
        for (int i = 0; i < envSize.get(); ++i) {
            Text key = new Text();
            Text value = new Text();
            key.readFields(in);
            value.readFields(in);
            this.environment.put(key.toString(), value.toString());
        }
        Text taskCmdText = new Text();
        taskCmdText.readFields(in);
        this.taskCmd = taskCmdText.toString();
        this.taskType = (TaskType)WritableUtils.readEnum((DataInput)in, TaskType.class);
        this.timeout = WritableUtils.readVLong((DataInput)in);
    }

    public final String toString() {
        return "TaskId: " + this.taskID.toString() + ", TaskType: " + (Object)((Object)this.taskType) + ", cmd: '" + this.taskCmd + "'";
    }
}

