/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineDataToRetrieve {
    private TimelineFilterList confsToRetrieve;
    private TimelineFilterList metricsToRetrieve;
    private EnumSet<TimelineReader.Field> fieldsToRetrieve;
    private Integer metricsLimit;
    private Long metricsTimeBegin;
    private Long metricsTimeEnd;
    private static final long DEFAULT_METRICS_BEGIN_TIME = 0L;
    private static final long DEFAULT_METRICS_END_TIME = Long.MAX_VALUE;
    public static final Integer DEFAULT_METRICS_LIMIT = 1;

    public TimelineDataToRetrieve() {
        this(null, null, null, null, null, null);
    }

    public TimelineDataToRetrieve(TimelineFilterList confs, TimelineFilterList metrics, EnumSet<TimelineReader.Field> fields, Integer limitForMetrics, Long metricTimeBegin, Long metricTimeEnd) {
        this.confsToRetrieve = confs;
        this.metricsToRetrieve = metrics;
        this.fieldsToRetrieve = fields;
        this.metricsLimit = limitForMetrics == null || limitForMetrics < 1 ? DEFAULT_METRICS_LIMIT : limitForMetrics;
        if (this.fieldsToRetrieve == null) {
            this.fieldsToRetrieve = EnumSet.noneOf(TimelineReader.Field.class);
        }
        this.metricsTimeBegin = metricTimeBegin == null || metricTimeBegin < 0L ? Long.valueOf(0L) : metricTimeBegin;
        this.metricsTimeEnd = metricTimeEnd == null || metricTimeEnd < 0L ? Long.valueOf(Long.MAX_VALUE) : metricTimeEnd;
        if (this.metricsTimeBegin > this.metricsTimeEnd) {
            throw new IllegalArgumentException("metricstimebegin should not be greater than metricstimeend");
        }
    }

    public TimelineFilterList getConfsToRetrieve() {
        return this.confsToRetrieve;
    }

    public void setConfsToRetrieve(TimelineFilterList confs) {
        this.confsToRetrieve = confs;
    }

    public TimelineFilterList getMetricsToRetrieve() {
        return this.metricsToRetrieve;
    }

    public void setMetricsToRetrieve(TimelineFilterList metrics) {
        this.metricsToRetrieve = metrics;
    }

    public EnumSet<TimelineReader.Field> getFieldsToRetrieve() {
        return this.fieldsToRetrieve;
    }

    public void setFieldsToRetrieve(EnumSet<TimelineReader.Field> fields) {
        this.fieldsToRetrieve = fields;
    }

    public void addFieldsBasedOnConfsAndMetricsToRetrieve() {
        if (!this.fieldsToRetrieve.contains((Object)TimelineReader.Field.CONFIGS) && this.confsToRetrieve != null && !this.confsToRetrieve.getFilterList().isEmpty()) {
            this.fieldsToRetrieve.add(TimelineReader.Field.CONFIGS);
        }
        if (!this.fieldsToRetrieve.contains((Object)TimelineReader.Field.METRICS) && this.metricsToRetrieve != null && !this.metricsToRetrieve.getFilterList().isEmpty()) {
            this.fieldsToRetrieve.add(TimelineReader.Field.METRICS);
        }
    }

    public Integer getMetricsLimit() {
        return this.metricsLimit;
    }

    public Long getMetricsTimeBegin() {
        return this.metricsTimeBegin;
    }

    public Long getMetricsTimeEnd() {
        return this.metricsTimeEnd;
    }

    public void setMetricsLimit(Integer limit) {
        this.metricsLimit = limit == null || limit < 1 ? DEFAULT_METRICS_LIMIT : limit;
    }
}

