/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.jsr107;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.shaded.javax.cache.Cache;
import org.apache.hadoop.shaded.javax.cache.integration.CacheLoader;
import org.apache.hadoop.shaded.javax.cache.integration.CacheWriter;
import org.apache.hadoop.shaded.org.ehcache.jsr107.internal.Jsr107CacheLoaderWriter;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.BulkCacheWritingException;

class Eh107CacheLoaderWriter<K, V>
implements Jsr107CacheLoaderWriter<K, V>,
Closeable {
    private final CacheLoader<K, V> cacheLoader;
    private final boolean readThrough;
    private final CacheWriter<K, V> cacheWriter;

    Eh107CacheLoaderWriter(CacheLoader<K, V> cacheLoader, boolean readThrough, CacheWriter<K, V> cacheWriter, boolean writeThrough) {
        this.cacheLoader = cacheLoader;
        this.readThrough = cacheLoader != null && readThrough;
        this.cacheWriter = writeThrough ? cacheWriter : null;
    }

    @Override
    public V load(K key) {
        if (this.readThrough) {
            return this.cacheLoader.load(key);
        }
        return null;
    }

    @Override
    public Map<K, V> loadAll(Iterable<? extends K> keys) {
        if (this.readThrough) {
            return this.loadAllAlways(keys);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<K, V> loadAllAlways(Iterable<? extends K> keys) {
        if (this.cacheLoader == null) {
            return Collections.emptyMap();
        }
        return this.cacheLoader.loadAll(keys);
    }

    @Override
    public void write(K key, V value) {
        if (this.cacheWriter != null) {
            this.cacheWriter.write(Eh107CacheLoaderWriter.cacheEntryFor(key, value));
        }
    }

    @Override
    public void delete(K key) {
        if (this.cacheWriter != null) {
            this.cacheWriter.delete(key);
        }
    }

    @Override
    public void deleteAll(Iterable<? extends K> keys) throws BulkCacheWritingException {
        if (this.cacheWriter != null) {
            HashSet<K> allKeys = new HashSet<K>();
            for (K key : keys) {
                allKeys.add(key);
            }
            try {
                this.cacheWriter.deleteAll(allKeys);
            }
            catch (Exception e) {
                Map<?, Exception> failures = this.failures(allKeys, e);
                Set<?> successes = this.successes(keys, failures.keySet());
                throw new BulkCacheWritingException(failures, successes);
            }
        }
    }

    private Set<?> successes(Iterable<? extends K> keys, Set<?> failures) {
        HashSet<K> set = new HashSet<K>();
        for (K key : keys) {
            if (failures.contains(key)) continue;
            set.add(key);
        }
        return set;
    }

    private Map<?, Exception> failures(Set<K> keys, Exception e) {
        HashMap<K, Exception> map = new HashMap<K, Exception>(keys.size());
        for (K key : keys) {
            map.put(key, e);
        }
        return map;
    }

    @Override
    public void writeAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        if (this.cacheWriter != null) {
            ArrayList toWrite = new ArrayList();
            for (Map.Entry<K, V> entry : entries) {
                toWrite.add(Eh107CacheLoaderWriter.cacheEntryFor(entry.getKey(), entry.getValue()));
            }
            try {
                this.cacheWriter.writeAll(toWrite);
            }
            catch (Exception e) {
                HashMap failures = new HashMap();
                for (Cache.Entry entry : toWrite) {
                    failures.put(entry.getKey(), e);
                }
                HashSet<K> successes = new HashSet<K>();
                for (Map.Entry<K, V> entry : entries) {
                    K key = entry.getKey();
                    if (failures.containsKey(key)) continue;
                    successes.add(key);
                }
                throw new BulkCacheWritingException(failures, successes);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.cacheLoader instanceof Closeable) {
                ((Closeable)((Object)this.cacheLoader)).close();
            }
        }
        finally {
            if (this.cacheWriter instanceof Closeable) {
                ((Closeable)((Object)this.cacheWriter)).close();
            }
        }
    }

    private static <K, V> Cache.Entry<K, V> cacheEntryFor(K key, V value) {
        return new Entry<K, V>(key, value);
    }

    static class Entry<K, V>
    implements Cache.Entry<K, V> {
        private final K key;
        private final V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            throw new IllegalArgumentException();
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                V value2;
                V value1;
                K key2;
                Entry other = (Entry)obj;
                K key1 = this.getKey();
                if ((key1 == (key2 = other.getKey()) || key1 != null && key1.equals(key2)) && ((value1 = this.getValue()) == (value2 = other.getValue()) || value1 != null && value1.equals(value2))) {
                    return true;
                }
            }
            return false;
        }
    }
}

