/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.unix;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.shaded.org.apache.commons.io.FileUtils;

public class TemporarySocketDirectory
implements Closeable {
    private File dir;

    public TemporarySocketDirectory() {
        String tmp = System.getProperty("java.io.tmpdir", "/tmp");
        this.dir = new File(tmp, "socks." + System.nanoTime());
        this.dir.mkdirs();
        FileUtil.setWritable((File)this.dir, (boolean)true);
    }

    public File getDir() {
        return this.dir;
    }

    @Override
    public void close() throws IOException {
        if (this.dir != null) {
            FileUtils.deleteDirectory((File)this.dir);
            this.dir = null;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

