/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.BackpressureUtils;

public final class OnSubscribeRepeating<T>
implements Observable.OnSubscribe<T> {
    private final T value;

    public OnSubscribeRepeating(T value) {
        this.value = value;
    }

    public void call(Subscriber<? super T> subscriber) {
        RepeatingProducer<? super T> producer = new RepeatingProducer<T>(subscriber, this.value);
        subscriber.setProducer(producer);
    }

    private static final class RepeatingProducer<T>
    extends AtomicLong
    implements Producer {
        private final Subscriber<? super T> subscriber;
        private final T v;

        public RepeatingProducer(Subscriber<? super T> subscriber, T v) {
            this.subscriber = subscriber;
            this.v = v;
        }

        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("reuest must be >=0");
            }
            if (n == 0L) {
                return;
            }
            if (BackpressureUtils.getAndAddRequest((AtomicLong)this, (long)n) == 0L) {
                long requested = n;
                long emitted = 0L;
                do {
                    emitted = requested;
                    while (requested-- > 0L && !this.subscriber.isUnsubscribed()) {
                        this.subscriber.onNext(this.v);
                    }
                } while ((requested = this.addAndGet(-emitted)) > 0L);
            }
        }
    }
}

