/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@FunctionalInterface
public interface Converter<T, E extends Throwable> {
    public static final Converter<?, RuntimeException> DEFAULT = s2 -> s2;
    public static final Converter<Class<?>, ClassNotFoundException> CLASS = Class::forName;
    public static final Converter<File, NullPointerException> FILE = File::new;
    public static final Converter<Path, InvalidPathException> PATH = x$0 -> Paths.get(x$0, new String[0]);
    public static final Converter<Number, NumberFormatException> NUMBER = s2 -> s2.indexOf(46) != -1 ? (Number)Double.valueOf(s2) : (Number)Long.valueOf(s2);
    public static final Converter<Object, ReflectiveOperationException> OBJECT = s2 -> CLASS.apply(s2).getConstructor(new Class[0]).newInstance(new Object[0]);
    public static final Converter<URL, MalformedURLException> URL = URL::new;
    public static final Converter<Date, ParseException> DATE = s2 -> new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(s2);

    public T apply(String var1) throws E;
}

