/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.opendal.Operator;

public class OpenDalUtil {
    private OpenDalUtil() {
    }

    public static Operator initializeOperator(String root, Map<String, String> storageOptions) {
        String[] schemeSplit = root.split("://", -1);
        if (schemeSplit.length < 2) {
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("root", root);
            if (storageOptions != null) {
                config.putAll(storageOptions);
            }
            return Operator.of((String)"fs", config);
        }
        String scheme = OpenDalUtil.normalizeScheme(schemeSplit[0]);
        String[] authoritySplit = schemeSplit[1].split("/", 2);
        String authority = authoritySplit[0];
        String path = authoritySplit.length > 1 ? authoritySplit[1] : "";
        HashMap<String, String> config = new HashMap<String, String>();
        switch (scheme) {
            case "s3": 
            case "gcs": {
                config.put("root", path);
                config.put("bucket", authority);
                break;
            }
            case "azblob": {
                config.put("root", path);
                config.put("CONTAINER", authority);
                break;
            }
            default: {
                config.put("root", schemeSplit[1]);
            }
        }
        if (storageOptions != null) {
            config.putAll(storageOptions);
        }
        return Operator.of((String)scheme, config);
    }

    public static String normalizeScheme(String scheme) {
        switch (scheme.toLowerCase()) {
            case "s3a": 
            case "s3n": {
                return "s3";
            }
            case "abfs": 
            case "az": {
                return "azblob";
            }
            case "file": {
                return "fs";
            }
        }
        return scheme.toLowerCase();
    }

    public static String denormalizeScheme(String scheme) {
        switch (scheme.toLowerCase()) {
            case "azblob": {
                return "az";
            }
        }
        return scheme.toLowerCase();
    }

    public static String denormalizeUri(String uri) {
        if (uri == null) {
            return null;
        }
        String[] schemeSplit = uri.split("://", 2);
        if (schemeSplit.length < 2) {
            return uri;
        }
        String scheme = schemeSplit[0];
        String denormalizedScheme = OpenDalUtil.denormalizeScheme(scheme);
        if (denormalizedScheme.equals(scheme)) {
            return uri;
        }
        return denormalizedScheme + "://" + schemeSplit[1];
    }

    public static String stripTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        String result = path;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

