/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class WritableConstantHiveDecimalObjectInspector
extends WritableHiveDecimalObjectInspector
implements ConstantObjectInspector {
    private HiveDecimalWritable value;

    protected WritableConstantHiveDecimalObjectInspector() {
    }

    WritableConstantHiveDecimalObjectInspector(DecimalTypeInfo typeInfo, HiveDecimalWritable value) {
        super(typeInfo);
        this.value = value;
    }

    public HiveDecimalWritable getWritableConstantValue() {
        DecimalTypeInfo decTypeInfo = (DecimalTypeInfo)this.typeInfo;
        HiveDecimalWritable result = new HiveDecimalWritable(this.value);
        result.mutateEnforcePrecisionScale(decTypeInfo.precision(), decTypeInfo.scale());
        if (!result.isSet()) {
            return null;
        }
        return result;
    }

    @Override
    public int precision() {
        if (this.value == null) {
            return super.precision();
        }
        return this.value.precision();
    }

    @Override
    public int scale() {
        if (this.value == null) {
            return super.scale();
        }
        return this.value.getHiveDecimal().scale();
    }
}

