/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package grails.plugin.scaffolding

import grails.plugins.Plugin
import grails.util.Environment
import grails.util.Metadata

class ScaffoldingGrailsPlugin extends Plugin {

   // the version or versions of Grails the plugin is designed for
    def grailsVersion = '7.0.0-SNAPSHOT > *'
    // resources that are excluded from plugin packaging
    def pluginExcludes = [
            'grails-app/views/error.gsp'
    ]

    def title = 'Scaffolding Plugin' // Headline display name of the plugin
    def author = 'Graeme Rocher'
    def authorEmail = 'info@grails.org'
    def description = '''\
Plugin that generates scaffolded controllers and views for a Grails application.
'''

    // URL to the plugin's documentation
    def documentation = 'https://docs.grails.org/latest/guide/scaffolding.html'

    // Extra (optional) plugin metadata

    // License: one of 'APACHE', 'GPL2', 'GPL3'
    def license = 'APACHE'

    // Location of the plugin's issue tracker.
    def issueManagement = [system: 'Github', url: 'https://github.com/grails3-plugins/scaffolding/issues']

    // Online location of the plugin's browseable source code.
    def scm = [ url: 'https://github.com/grails3-plugins/scaffolding']

    def loadAfter = ['groovyPages']

    @Override
    Closure doWithSpring() {
        { ->
            Environment env = Environment.current
            boolean reloadEnabled = env.isReloadEnabled() || (Metadata.getCurrent().isDevelopmentEnvironmentAvailable() && env == Environment.DEVELOPMENT)

            // Configure a Spring MVC view resolver
            jspViewResolver(ScaffoldingViewResolver) { bean ->
                bean.lazyInit = true
                bean.parent = 'abstractViewResolver'
                enableReload = reloadEnabled
            }
        }
    }
}
