/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import io.micronaut.context.annotation.Primary;
import jakarta.inject.Singleton;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.FeatureContext;
import org.grails.forge.feature.config.ApplicationConfiguration;
import org.grails.forge.feature.database.DatabaseDriverConfigurationFeature;
import org.grails.forge.feature.database.DatabaseDriverFeature;
import org.grails.forge.feature.database.GormFeature;
import org.grails.forge.options.GormImpl;
import org.grails.forge.options.Options;

@Primary
@Singleton
public class HibernateGorm
extends GormFeature
implements DatabaseDriverConfigurationFeature {
    static final String PREFIX = "dataSource.";
    private static final String URL_KEY = "dataSource.url";
    private static final String DRIVER_KEY = "dataSource.driverClassName";
    private static final String USERNAME_KEY = "dataSource.username";
    private static final String PASSWORD_KEY = "dataSource.password";
    private static final String DB_CREATE_KEY = "dataSource.dbCreate";
    private final DatabaseDriverFeature defaultDbFeature;

    public HibernateGorm(DatabaseDriverFeature defaultDbFeature) {
        this.defaultDbFeature = defaultDbFeature;
    }

    @Override
    public String getName() {
        return "gorm-hibernate5";
    }

    @Override
    public String getTitle() {
        return "GORM for Hibernate 5";
    }

    @Override
    public String getDescription() {
        return "Configure GORM for using Hibernate 5.";
    }

    @Override
    public void processSelectedFeatures(FeatureContext featureContext) {
        if (!featureContext.isPresent(DatabaseDriverFeature.class)) {
            featureContext.addFeature(this.defaultDbFeature);
        }
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        ApplicationConfiguration config = generatorContext.getConfiguration();
        DatabaseDriverFeature dbFeature = generatorContext.getRequiredFeature(DatabaseDriverFeature.class);
        this.applyDefaultConfig(dbFeature, config);
        this.applyDefaultGormConfig(config);
        config.put("dataSource.pooled", true);
        config.put("dataSource.jmxExport", true);
        config.put("hibernate.cache.queries", false);
        config.put("hibernate.cache.use_second_level_cache", false);
        config.put("hibernate.cache.use_query_cache", false);
        generatorContext.addBuildscriptDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-data-hibernate5").buildSrc());
        generatorContext.addDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-data-hibernate5").implementation());
        generatorContext.addDependency(Dependency.builder().groupId("com.zaxxer").artifactId("HikariCP").runtimeOnly());
    }

    @Override
    public String getUrlKey() {
        return URL_KEY;
    }

    @Override
    public String getDriverKey() {
        return DRIVER_KEY;
    }

    @Override
    public String getUsernameKey() {
        return USERNAME_KEY;
    }

    @Override
    public String getPasswordKey() {
        return PASSWORD_KEY;
    }

    @Override
    public String getDbCreateKey() {
        return DB_CREATE_KEY;
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return selectedFeatures.stream().anyMatch(f -> f instanceof HibernateGorm) || options.getGormImpl() == GormImpl.HIBERNATE;
    }
}

