/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.query.criteria;

import grails.gorm.DetachedCriteria;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovySystem;
import groovy.lang.MetaMethod;
import groovy.lang.MetaObjectProtocol;
import groovy.lang.MissingMethodException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.QueryCreator;
import org.grails.datastore.mapping.query.Restrictions;
import org.grails.datastore.mapping.query.api.Criteria;
import org.grails.datastore.mapping.query.api.ProjectionList;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.springframework.util.Assert;

public abstract class AbstractCriteriaBuilder
extends GroovyObjectSupport
implements Criteria,
ProjectionList {
    public static final String ORDER_DESCENDING = "desc";
    public static final String ORDER_ASCENDING = "asc";
    protected static final String ROOT_CALL = "call";
    protected static final String ROOT_DO_CALL = "doCall";
    protected static final String SCROLL_CALL = "scroll";
    protected final Class targetClass;
    protected final QueryCreator queryCreator;
    protected Query query;
    protected boolean uniqueResult = false;
    protected boolean paginationEnabledList;
    protected List<Query.Order> orderEntries = new ArrayList<Query.Order>();
    protected MetaObjectProtocol queryMetaClass;
    protected Query.ProjectionList projectionList;
    protected PersistentEntity persistentEntity;
    protected boolean readOnly;
    private List<Query.Junction> logicalExpressionStack = new ArrayList<Query.Junction>();

    public AbstractCriteriaBuilder(Class targetClass, QueryCreator queryCreator, MappingContext mappingContext) {
        Assert.notNull((Object)targetClass, "Argument [targetClass] cannot be null");
        Assert.notNull((Object)mappingContext, "Argument [session] cannot be null");
        this.persistentEntity = mappingContext.getPersistentEntity(targetClass.getName());
        if (this.persistentEntity == null) {
            throw new IllegalArgumentException("Class [" + targetClass.getName() + "] is not a persistent entity");
        }
        this.targetClass = targetClass;
        this.queryCreator = queryCreator;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setUniqueResult(boolean uniqueResult) {
        this.uniqueResult = uniqueResult;
    }

    @Override
    public Criteria cache(boolean cache) {
        this.query.cache(cache);
        return this;
    }

    @Override
    public Criteria readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Criteria join(String property) {
        this.query.join(property);
        return this;
    }

    public Criteria select(String property) {
        this.query.select(property);
        return this;
    }

    @Override
    public Query.ProjectionList id() {
        if (this.projectionList != null) {
            this.projectionList.id();
        }
        return this.projectionList;
    }

    @Override
    public Query.ProjectionList count() {
        if (this.projectionList != null) {
            this.projectionList.count();
        }
        return this.projectionList;
    }

    @Override
    public ProjectionList countDistinct(String property) {
        if (this.projectionList != null) {
            this.projectionList.countDistinct(property);
        }
        return this.projectionList;
    }

    @Override
    public ProjectionList groupProperty(String property) {
        if (this.projectionList != null) {
            this.projectionList.groupProperty(property);
        }
        return this.projectionList;
    }

    @Override
    public ProjectionList distinct() {
        if (this.projectionList != null) {
            this.projectionList.distinct();
        }
        return this.projectionList;
    }

    @Override
    public ProjectionList distinct(String property) {
        if (this.projectionList != null) {
            this.projectionList.distinct(property);
        }
        return this.projectionList;
    }

    @Override
    public ProjectionList rowCount() {
        return this.count();
    }

    @Override
    public ProjectionList property(String name) {
        if (this.projectionList != null) {
            this.projectionList.property(name);
        }
        return this.projectionList;
    }

    @Override
    public ProjectionList sum(String name) {
        if (this.projectionList != null) {
            this.projectionList.sum(name);
        }
        return this.projectionList;
    }

    @Override
    public ProjectionList min(String name) {
        if (this.projectionList != null) {
            this.projectionList.min(name);
        }
        return this.projectionList;
    }

    @Override
    public ProjectionList max(String name) {
        if (this.projectionList != null) {
            this.projectionList.max(name);
        }
        return this.projectionList;
    }

    @Override
    public ProjectionList avg(String name) {
        if (this.projectionList != null) {
            this.projectionList.avg(name);
        }
        return this.projectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeMethod(String name, Object obj) {
        PersistentProperty property;
        Object[] objectArray;
        if (obj.getClass().isArray()) {
            objectArray = (Object[])obj;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = obj;
        }
        Object[] args = objectArray;
        this.ensureQueryIsInitialized();
        if (this.isCriteriaConstructionMethod(name, args)) {
            this.uniqueResult = false;
            this.invokeClosureNode(args[0]);
            Object result = !this.uniqueResult ? this.invokeList() : this.query.singleResult();
            this.query = null;
            return result;
        }
        MetaMethod metaMethod = this.getMetaClass().getMetaMethod(name, args);
        if (metaMethod != null) {
            return metaMethod.invoke(this, args);
        }
        metaMethod = this.queryMetaClass.getMetaMethod(name, args);
        if (metaMethod != null) {
            return metaMethod.invoke(this.query, args);
        }
        if (args.length == 1 && args[0] instanceof Closure && (property = this.persistentEntity.getPropertyByName(name)) instanceof Association) {
            Association association = (Association)property;
            Query previousQuery = this.query;
            PersistentEntity previousEntity = this.persistentEntity;
            List<Query.Junction> previousLogicalExpressionStack = this.logicalExpressionStack;
            AssociationQuery associationQuery = null;
            try {
                associationQuery = this.query.createQuery(property.getName());
                if (associationQuery instanceof AssociationQuery) {
                    this.addToCriteria(associationQuery);
                }
                this.query = associationQuery;
                this.persistentEntity = association.getAssociatedEntity();
                this.logicalExpressionStack = new ArrayList<Query.Junction>();
                this.invokeClosureNode(args[0]);
                Query query = this.query;
                return query;
            }
            finally {
                this.logicalExpressionStack = previousLogicalExpressionStack;
                this.persistentEntity = previousEntity;
                this.query = previousQuery;
            }
        }
        throw new MissingMethodException(name, this.getClass(), args);
    }

    protected Object invokeList() {
        List result = this.query.list();
        return result;
    }

    public ProjectionList projections(Closure callable) {
        this.projectionList = this.query.projections();
        this.invokeClosureNode(callable);
        return this.projectionList;
    }

    @Override
    public Criteria and(Closure callable) {
        this.handleJunction(new Query.Conjunction(), callable);
        return this;
    }

    @Override
    public Criteria or(Closure callable) {
        this.handleJunction(new Query.Disjunction(), callable);
        return this;
    }

    @Override
    public Criteria not(Closure callable) {
        this.handleJunction(new Query.Negation(), callable);
        return this;
    }

    @Override
    public Criteria idEquals(Object value) {
        this.addToCriteria(Restrictions.idEq(value));
        return this;
    }

    @Override
    public Criteria exists(QueryableCriteria<?> subquery) {
        this.addToCriteria(new Query.Exists(subquery));
        return this;
    }

    @Override
    public Criteria notExists(QueryableCriteria<?> subquery) {
        this.addToCriteria(new Query.NotExists(subquery));
        return this;
    }

    @Override
    public Criteria isEmpty(String propertyName) {
        this.validatePropertyName(propertyName, "isEmpty");
        this.addToCriteria(Restrictions.isEmpty(propertyName));
        return this;
    }

    @Override
    public Criteria isNotEmpty(String propertyName) {
        this.validatePropertyName(propertyName, "isNotEmpty");
        this.addToCriteria(Restrictions.isNotEmpty(propertyName));
        return this;
    }

    @Override
    public Criteria isNull(String propertyName) {
        this.validatePropertyName(propertyName, "isNull");
        this.addToCriteria(Restrictions.isNull(propertyName));
        return this;
    }

    @Override
    public Criteria isNotNull(String propertyName) {
        this.validatePropertyName(propertyName, "isNotNull");
        this.addToCriteria(Restrictions.isNotNull(propertyName));
        return this;
    }

    @Override
    public Criteria eq(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "eq");
        this.addToCriteria(Restrictions.eq(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria allEq(Map<String, Object> propertyValues) {
        Query.Conjunction conjunction = new Query.Conjunction();
        for (String property : propertyValues.keySet()) {
            conjunction.add(Restrictions.eq(property, propertyValues.get(property)));
        }
        this.addToCriteria(conjunction);
        return this;
    }

    public Criteria eqAll(String propertyName, Closure propertyValue) {
        return this.eqAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    private QueryableCriteria buildQueryableCriteria(Closure queryClosure) {
        return new DetachedCriteria(this.targetClass).build(queryClosure);
    }

    public Criteria gtAll(String propertyName, Closure propertyValue) {
        return this.gtAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria ltAll(String propertyName, Closure propertyValue) {
        return this.ltAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria geAll(String propertyName, Closure propertyValue) {
        return this.geAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    public Criteria leAll(String propertyName, Closure propertyValue) {
        return this.leAll(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    @Override
    public Criteria eqAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "eqAll");
        this.addToCriteria(new Query.EqualsAll(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria gtAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "gtAll");
        this.addToCriteria(new Query.GreaterThanAll(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria gtSome(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "gtSome");
        this.addToCriteria(new Query.GreaterThanSome(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria gtSome(String propertyName, Closure<?> propertyValue) {
        return this.gtSome(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    @Override
    public Criteria geSome(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "geSome");
        this.addToCriteria(new Query.GreaterThanEqualsSome(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria geSome(String propertyName, Closure<?> propertyValue) {
        return this.geSome(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    @Override
    public Criteria ltSome(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "ltSome");
        this.addToCriteria(new Query.LessThanEqualsSome(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria ltSome(String propertyName, Closure<?> propertyValue) {
        return this.ltSome(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    @Override
    public Criteria leSome(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "leSome");
        this.addToCriteria(new Query.LessThanEqualsSome(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria leSome(String propertyName, Closure<?> propertyValue) {
        return this.leSome(propertyName, this.buildQueryableCriteria(propertyValue));
    }

    @Override
    public Criteria in(String propertyName, QueryableCriteria<?> subquery) {
        return this.inList(propertyName, subquery);
    }

    @Override
    public Criteria in(String propertyName, Closure<?> subquery) {
        return this.inList(propertyName, subquery);
    }

    @Override
    public Criteria inList(String propertyName, QueryableCriteria<?> subquery) {
        this.validatePropertyName(propertyName, "inList");
        this.addToCriteria(new Query.In(propertyName, subquery));
        return this;
    }

    @Override
    public Criteria inList(String propertyName, Closure<?> subquery) {
        return this.inList(propertyName, this.buildQueryableCriteria(subquery));
    }

    @Override
    public Criteria notIn(String propertyName, QueryableCriteria<?> subquery) {
        this.validatePropertyName(propertyName, "notIn");
        this.addToCriteria(new Query.NotIn(propertyName, subquery));
        return this;
    }

    @Override
    public Criteria notIn(String propertyName, Closure<?> subquery) {
        return this.notIn(propertyName, this.buildQueryableCriteria(subquery));
    }

    @Override
    public Criteria ltAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "ltAll");
        this.addToCriteria(new Query.LessThanAll(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria geAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "geAll");
        this.addToCriteria(new Query.GreaterThanEqualsAll(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria leAll(String propertyName, QueryableCriteria propertyValue) {
        this.validatePropertyName(propertyName, "leAll");
        this.addToCriteria(new Query.LessThanEqualsAll(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria idEq(Object propertyValue) {
        this.addToCriteria(Restrictions.idEq(propertyValue));
        return this;
    }

    @Override
    public Criteria ne(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "ne");
        this.addToCriteria(Restrictions.ne(propertyName, propertyValue));
        return this;
    }

    @Override
    public Criteria between(String propertyName, Object start, Object finish) {
        this.validatePropertyName(propertyName, "between");
        this.addToCriteria(Restrictions.between(propertyName, start, finish));
        return this;
    }

    @Override
    public Criteria gte(String property, Object value) {
        this.validatePropertyName(property, "gte");
        this.addToCriteria(Restrictions.gte(property, value));
        return this;
    }

    @Override
    public Criteria ge(String property, Object value) {
        this.gte(property, value);
        return this;
    }

    @Override
    public Criteria gt(String property, Object value) {
        this.validatePropertyName(property, "gt");
        this.addToCriteria(Restrictions.gt(property, value));
        return this;
    }

    @Override
    public Criteria lte(String property, Object value) {
        this.validatePropertyName(property, "lte");
        this.addToCriteria(Restrictions.lte(property, value));
        return this;
    }

    @Override
    public Criteria le(String property, Object value) {
        this.lte(property, value);
        return this;
    }

    @Override
    public Criteria lt(String property, Object value) {
        this.validatePropertyName(property, "lt");
        this.addToCriteria(Restrictions.lt(property, value));
        return this;
    }

    @Override
    public Criteria like(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "like");
        Assert.notNull(propertyValue, "Cannot use like expression with null value");
        this.addToCriteria(Restrictions.like(propertyName, propertyValue.toString()));
        return this;
    }

    @Override
    public Criteria ilike(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "ilike");
        Assert.notNull(propertyValue, "Cannot use ilike expression with null value");
        this.addToCriteria(Restrictions.ilike(propertyName, propertyValue.toString()));
        return this;
    }

    @Override
    public Criteria rlike(String propertyName, Object propertyValue) {
        this.validatePropertyName(propertyName, "like");
        Assert.notNull(propertyValue, "Cannot use like expression with null value");
        this.addToCriteria(Restrictions.rlike(propertyName, propertyValue.toString()));
        return this;
    }

    @Override
    public Criteria in(String propertyName, Collection values) {
        this.validatePropertyName(propertyName, "in");
        Assert.notNull((Object)values, "Cannot use in expression with null values");
        this.addToCriteria(Restrictions.in(propertyName, values));
        return this;
    }

    @Override
    public Criteria inList(String propertyName, Collection values) {
        this.in(propertyName, values);
        return this;
    }

    @Override
    public Criteria inList(String propertyName, Object[] values) {
        return this.in(propertyName, Arrays.asList(values));
    }

    @Override
    public Criteria in(String propertyName, Object[] values) {
        return this.in(propertyName, Arrays.asList(values));
    }

    @Override
    public Criteria sizeEq(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeEq");
        this.addToCriteria(Restrictions.sizeEq(propertyName, size));
        return this;
    }

    @Override
    public Criteria sizeGt(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeGt");
        this.addToCriteria(Restrictions.sizeGt(propertyName, size));
        return this;
    }

    @Override
    public Criteria sizeGe(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeGe");
        this.addToCriteria(Restrictions.sizeGe(propertyName, size));
        return this;
    }

    @Override
    public Criteria sizeLe(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeLe");
        this.addToCriteria(Restrictions.sizeLe(propertyName, size));
        return this;
    }

    @Override
    public Criteria sizeLt(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeLt");
        this.addToCriteria(Restrictions.sizeLt(propertyName, size));
        return this;
    }

    @Override
    public Criteria sizeNe(String propertyName, int size) {
        this.validatePropertyName(propertyName, "sizeNe");
        this.addToCriteria(Restrictions.sizeNe(propertyName, size));
        return this;
    }

    @Override
    public Criteria eqProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "eqProperty");
        this.validatePropertyName(otherPropertyName, "eqProperty");
        this.addToCriteria(Restrictions.eqProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    public Criteria neProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "neProperty");
        this.validatePropertyName(otherPropertyName, "neProperty");
        this.addToCriteria(Restrictions.neProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    public Criteria gtProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "gtProperty");
        this.validatePropertyName(otherPropertyName, "gtProperty");
        this.addToCriteria(Restrictions.gtProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    public Criteria geProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "geProperty");
        this.validatePropertyName(otherPropertyName, "geProperty");
        this.addToCriteria(Restrictions.geProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    public Criteria ltProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "ltProperty");
        this.validatePropertyName(otherPropertyName, "ltProperty");
        this.addToCriteria(Restrictions.ltProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    public Criteria leProperty(String propertyName, String otherPropertyName) {
        this.validatePropertyName(propertyName, "leProperty");
        this.validatePropertyName(otherPropertyName, "leProperty");
        this.addToCriteria(Restrictions.leProperty(propertyName, otherPropertyName));
        return this;
    }

    @Override
    public Criteria order(String propertyName) {
        Query.Order o = Query.Order.asc(propertyName);
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.query.order(o);
        }
        return this;
    }

    @Override
    public Criteria order(Query.Order o) {
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.query.order(o);
        }
        return this;
    }

    @Override
    public Criteria order(String propertyName, String direction) {
        Query.Order o = direction.equals(ORDER_DESCENDING) ? Query.Order.desc(propertyName) : Query.Order.asc(propertyName);
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.query.order(o);
        }
        return this;
    }

    protected void validatePropertyName(String propertyName, String methodName) {
        if (this.persistentEntity == null) {
            return;
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("Cannot use [" + methodName + "] restriction with null property name");
        }
        PersistentProperty property = this.persistentEntity.getPropertyByName(propertyName);
        if (property == null && this.persistentEntity.getIdentity().getName().equals(propertyName)) {
            property = this.persistentEntity.getIdentity();
        }
        if (property == null && !this.queryCreator.isSchemaless()) {
            throw new IllegalArgumentException("Property [" + propertyName + "] is not a valid property of class [" + String.valueOf(this.persistentEntity) + "]");
        }
    }

    protected void ensureQueryIsInitialized() {
        if (this.query == null) {
            this.query = this.queryCreator.createQuery(this.targetClass);
        }
        if (this.queryMetaClass == null) {
            this.queryMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.query.getClass());
        }
    }

    private boolean isCriteriaConstructionMethod(String name, Object[] args) {
        return name.equals(ROOT_CALL) || name.equals(ROOT_DO_CALL) || name.equals(SCROLL_CALL) && args.length == 1 && args[0] instanceof Closure;
    }

    protected void invokeClosureNode(Object args) {
        if (args instanceof Closure) {
            Closure callable = (Closure)args;
            callable.setDelegate(this);
            callable.setResolveStrategy(1);
            callable.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJunction(Query.Junction junction, Closure callable) {
        this.logicalExpressionStack.add(junction);
        try {
            if (callable != null) {
                this.invokeClosureNode(callable);
            }
        }
        finally {
            Query.Junction logicalExpression = this.logicalExpressionStack.remove(this.logicalExpressionStack.size() - 1);
            this.addToCriteria(logicalExpression);
        }
    }

    protected Query.Criterion addToCriteria(Query.Criterion c) {
        Query.PropertyCriterion pc;
        Object value;
        if (c instanceof Query.PropertyCriterion && (value = (pc = (Query.PropertyCriterion)c).getValue()) instanceof Closure) {
            pc.setValue(this.buildQueryableCriteria((Closure)value));
        }
        if (!this.logicalExpressionStack.isEmpty()) {
            this.logicalExpressionStack.get(this.logicalExpressionStack.size() - 1).add(c);
        } else {
            if (this.query == null) {
                this.ensureQueryIsInitialized();
            }
            this.query.add(c);
        }
        return c;
    }

    public Query getQuery() {
        return this.query;
    }

    public void build(Closure criteria) {
        if (criteria != null) {
            this.invokeClosureNode(criteria);
        }
    }
}

