/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.SlicedByteBuf;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

class ReadOnlyByteBufferBuf
extends AbstractReferenceCountedByteBuf {
    protected final ByteBuffer buffer;
    private final ByteBufAllocator allocator;
    private ByteBuffer tmpNioBuf;

    ReadOnlyByteBufferBuf(ByteBufAllocator allocator, ByteBuffer buffer) {
        super(buffer.remaining());
        if (!buffer.isReadOnly()) {
            throw new IllegalArgumentException("must be a readonly buffer: " + StringUtil.simpleClassName(buffer));
        }
        this.allocator = allocator;
        this.buffer = buffer.slice().order(ByteOrder.BIG_ENDIAN);
        this.writerIndex(this.buffer.limit());
    }

    @Override
    protected void deallocate() {
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isWritable(int numBytes) {
        return false;
    }

    @Override
    public ByteBuf ensureWritable(int minWritableBytes) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        return 1;
    }

    @Override
    public byte getByte(int index2) {
        this.ensureAccessible();
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return this.buffer.get(index2);
    }

    @Override
    public short getShort(int index2) {
        this.ensureAccessible();
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return this.buffer.getShort(index2);
    }

    @Override
    public short getShortLE(int index2) {
        this.ensureAccessible();
        return this._getShortLE(index2);
    }

    @Override
    protected short _getShortLE(int index2) {
        return ByteBufUtil.swapShort(this.buffer.getShort(index2));
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return (this.getByte(index2) & 0xFF) << 16 | (this.getByte(index2 + 1) & 0xFF) << 8 | this.getByte(index2 + 2) & 0xFF;
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        this.ensureAccessible();
        return this._getUnsignedMediumLE(index2);
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return this.getByte(index2) & 0xFF | (this.getByte(index2 + 1) & 0xFF) << 8 | (this.getByte(index2 + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int index2) {
        this.ensureAccessible();
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return this.buffer.getInt(index2);
    }

    @Override
    public int getIntLE(int index2) {
        this.ensureAccessible();
        return this._getIntLE(index2);
    }

    @Override
    protected int _getIntLE(int index2) {
        return ByteBufUtil.swapInt(this.buffer.getInt(index2));
    }

    @Override
    public long getLong(int index2) {
        this.ensureAccessible();
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return this.buffer.getLong(index2);
    }

    @Override
    public long getLongLE(int index2) {
        this.ensureAccessible();
        return this._getLongLE(index2);
    }

    @Override
    protected long _getLongLE(int index2) {
        return ByteBufUtil.swapLong(this.buffer.getLong(index2));
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        return this.getBytes(index2, dst, dstIndex, length, false);
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst, dstIndex, length, true);
        this.readerIndex += length;
        return this;
    }

    protected ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length, boolean internal) {
        this.checkDstIndex(index2, length, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            this.getBytes(index2, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else if (dst.nioBufferCount() > 0) {
            for (ByteBuffer bb : dst.nioBuffers(dstIndex, length)) {
                int bbLen = bb.remaining();
                this.getBytes(index2, bb, internal);
                index2 += bbLen;
            }
        } else {
            dst.setBytes(dstIndex, this, index2, length);
        }
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        return this.getBytes(index2, dst, dstIndex, length, false);
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst, dstIndex, length, true);
        this.readerIndex += length;
        return this;
    }

    protected ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length, boolean internal) {
        this.checkDstIndex(index2, length, dstIndex, dst.length);
        ByteBuffer tmpBuf = this.nioBuffer(internal);
        tmpBuf.clear().position(index2).limit(index2 + length);
        tmpBuf.get(dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        return this.getBytes(index2, dst, false);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        int length = dst.remaining();
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, dst, true);
        this.readerIndex += length;
        return this;
    }

    private ByteBuf getBytes(int index2, ByteBuffer dst, boolean internal) {
        this.checkIndex(index2, dst.remaining());
        ByteBuffer tmpBuf = this.nioBuffer(internal);
        tmpBuf.clear().position(index2).limit(index2 + dst.remaining());
        dst.put(tmpBuf);
        return this;
    }

    @Override
    public ByteBuf setByte(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setByte(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShort(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShort(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setShortLE(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setShortLE(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMedium(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMedium(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setMediumLE(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setInt(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setInt(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setIntLE(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setIntLE(int index2, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLong(int index2, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLong(int index2, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setLongLE(int index2, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void _setLongLE(int index2, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int capacity() {
        return this.maxCapacity();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        return this.getBytes(index2, out, length, false);
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        this.checkReadableBytes(length);
        this.getBytes(this.readerIndex, out, length, true);
        this.readerIndex += length;
        return this;
    }

    private ByteBuf getBytes(int index2, OutputStream out, int length, boolean internal) throws IOException {
        this.ensureAccessible();
        if (length == 0) {
            return this;
        }
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), index2 + this.buffer.arrayOffset(), length);
        } else {
            byte[] tmp = ByteBufUtil.threadLocalTempArray(length);
            ByteBuffer tmpBuf = this.nioBuffer(internal);
            tmpBuf.clear().position(index2);
            tmpBuf.get(tmp, 0, length);
            out.write(tmp, 0, length);
        }
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        return this.getBytes(index2, out, length, false);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        this.checkReadableBytes(length);
        int readBytes = this.getBytes(this.readerIndex, out, length, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    private int getBytes(int index2, GatheringByteChannel out, int length, boolean internal) throws IOException {
        this.ensureAccessible();
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.nioBuffer(internal);
        tmpBuf.clear().position(index2).limit(index2 + length);
        return out.write(tmpBuf);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length) throws IOException {
        return this.getBytes(index2, out, position, length, false);
    }

    @Override
    public int readBytes(FileChannel out, long position, int length) throws IOException {
        this.checkReadableBytes(length);
        int readBytes = this.getBytes(this.readerIndex, out, position, length, true);
        this.readerIndex += readBytes;
        return readBytes;
    }

    private int getBytes(int index2, FileChannel out, long position, int length, boolean internal) throws IOException {
        this.ensureAccessible();
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.nioBuffer(internal);
        tmpBuf.clear().position(index2).limit(index2 + length);
        return out.write(tmpBuf, position);
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer tmpNioBuf = this.tmpNioBuf;
        if (tmpNioBuf == null) {
            this.tmpNioBuf = tmpNioBuf = this.buffer.duplicate();
        }
        return tmpNioBuf;
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        ByteBuffer src;
        this.ensureAccessible();
        try {
            src = (ByteBuffer)this.buffer.duplicate().clear().position(index2).limit(index2 + length);
        }
        catch (IllegalArgumentException ignored) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Need " + (index2 + length));
        }
        ByteBuf dst = src.isDirect() ? this.alloc().directBuffer(length) : this.alloc().heapBuffer(length);
        dst.writeBytes(src);
        return dst;
    }

    @Override
    public int nioBufferCount() {
        return 1;
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        return new ByteBuffer[]{this.nioBuffer(index2, length)};
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length) {
        this.checkIndex(index2, length);
        return (ByteBuffer)this.buffer.duplicate().position(index2).limit(index2 + length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length) {
        this.ensureAccessible();
        return (ByteBuffer)this.internalNioBuffer().clear().position(index2).limit(index2 + length);
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    private ByteBuffer nioBuffer(boolean internal) {
        return internal ? this.internalNioBuffer() : this.buffer.duplicate();
    }

    @Override
    public ByteBuf duplicate() {
        return new ReadOnlyDuplicatedByteBuf(this);
    }

    @Override
    public ByteBuf slice(int index2, int length) {
        return new ReadOnlySlicedByteBuf(this, index2, length);
    }

    @Override
    public ByteBuf asReadOnly() {
        return this;
    }

    private static final class ReadOnlyDuplicatedByteBuf
    extends DuplicatedByteBuf {
        ReadOnlyDuplicatedByteBuf(ByteBuf buffer) {
            super(buffer);
        }

        @Override
        public ByteBuf asReadOnly() {
            return this;
        }

        @Override
        public ByteBuf slice(int index2, int length) {
            return new ReadOnlySlicedByteBuf(this, index2, length);
        }

        @Override
        public ByteBuf duplicate() {
            return new ReadOnlyDuplicatedByteBuf(this);
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isWritable(int numBytes) {
            return false;
        }

        @Override
        public int ensureWritable(int minWritableBytes, boolean force) {
            return 1;
        }
    }

    private static final class ReadOnlySlicedByteBuf
    extends SlicedByteBuf {
        ReadOnlySlicedByteBuf(ByteBuf buffer, int index2, int length) {
            super(buffer, index2, length);
        }

        @Override
        public ByteBuf asReadOnly() {
            return this;
        }

        @Override
        public ByteBuf slice(int index2, int length) {
            return new ReadOnlySlicedByteBuf(this, index2, length);
        }

        @Override
        public ByteBuf duplicate() {
            return this.slice(0, this.capacity()).setIndex(this.readerIndex(), this.writerIndex());
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public boolean isWritable(int numBytes) {
            return false;
        }

        @Override
        public int ensureWritable(int minWritableBytes, boolean force) {
            return 1;
        }
    }
}

