/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ArgumentCoercible;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface BeanProperty<B, T>
extends AnnotatedElement,
AnnotationMetadataDelegate,
ArgumentCoercible<T> {
    @NonNull
    public BeanIntrospection<B> getDeclaringBean();

    @Nullable
    public T get(@NonNull B var1);

    @NonNull
    default public <T2> Optional<T2> get(@NonNull B bean2, @NonNull Class<T2> type) {
        ArgumentUtils.requireNonNull("bean", bean2);
        ArgumentUtils.requireNonNull("type", type);
        Argument<T2> argument = Argument.of(type);
        return this.get(bean2, argument);
    }

    default public <T2> Optional<T2> get(@NonNull B bean2, @NonNull Argument<T2> argument) {
        ArgumentUtils.requireNonNull("bean", bean2);
        ArgumentUtils.requireNonNull("type", argument);
        ArgumentConversionContext<T2> conversionContext = ConversionContext.of(argument);
        return this.get(bean2, conversionContext);
    }

    default public <T2> Optional<T2> get(@NonNull B bean2, @NonNull ArgumentConversionContext<T2> conversionContext) {
        ArgumentUtils.requireNonNull("bean", bean2);
        ArgumentUtils.requireNonNull("conversionContext", conversionContext);
        T v = this.get(bean2);
        return ConversionService.SHARED.convert(v, conversionContext);
    }

    @Nullable
    default public <T2> T2 get(@NonNull B bean2, @NonNull Class<T2> type, @Nullable T2 defaultValue) {
        ArgumentUtils.requireNonNull("bean", bean2);
        if (type == null) {
            return defaultValue;
        }
        T v = this.get(bean2);
        return ConversionService.SHARED.convert(v, type).orElse(defaultValue);
    }

    default public boolean hasSetterOrConstructorArgument() {
        BeanIntrospection declaringBean = this.getDeclaringBean();
        return !this.isReadOnly() || Arrays.stream(declaringBean.getConstructorArguments()).anyMatch(arg -> declaringBean.getProperty(arg.getName(), arg.getType()).isPresent());
    }

    default public B withValue(@NonNull B bean2, @Nullable T value) {
        if (this.isReadOnly()) {
            Collection<BeanProperty<B, Object>> beanProperties;
            if (value == this.get(bean2)) {
                return bean2;
            }
            BeanIntrospection<B> declaringBean = this.getDeclaringBean();
            Argument<?>[] constructorArguments = declaringBean.getConstructorArguments();
            Object[] values = new Object[constructorArguments.length];
            boolean found = false;
            for (int i2 = 0; i2 < constructorArguments.length; ++i2) {
                Class argumentType;
                Argument<?> constructorArgument = constructorArguments[i2];
                String argumentName = constructorArgument.getName();
                BeanProperty prop = declaringBean.getProperty(argumentName, argumentType = constructorArgument.getType()).orElse(null);
                if (prop == null) {
                    throw new UnsupportedOperationException("Cannot create copy of type [" + declaringBean.getBeanType() + "]. Constructor contains argument [" + argumentName + "] that is not a readable property");
                }
                if (prop == this) {
                    found = true;
                    values[i2] = value;
                    continue;
                }
                values[i2] = prop.get(bean2);
            }
            if (found) {
                B newInstance = declaringBean.instantiate(values);
                beanProperties = declaringBean.getBeanProperties();
                for (BeanProperty<B, Object> beanProperty : beanProperties) {
                    if (beanProperty == this || !beanProperty.isReadWrite()) continue;
                    beanProperty.set(newInstance, beanProperty.get(bean2));
                }
                return newInstance;
            }
            B newInstance = declaringBean.instantiate(values);
            beanProperties = declaringBean.getBeanProperties();
            for (BeanProperty<B, Object> beanProperty : beanProperties) {
                if (beanProperty != this || !beanProperty.isReadWrite()) continue;
                found = true;
                beanProperty.set(newInstance, beanProperty.get(bean2));
            }
            if (!found) {
                throw new UnsupportedOperationException("Cannot mutate property [" + this.getName() + "] that is not mutable via a setter method or constructor argument for type: " + declaringBean.getBeanType().getName());
            }
            return newInstance;
        }
        this.set(bean2, value);
        return bean2;
    }

    default public void set(@NonNull B bean2, @Nullable T value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Cannot write read-only property: " + this.getName());
        }
        throw new UnsupportedOperationException("Write method unimplemented for property: " + this.getName());
    }

    default public void convertAndSet(@NonNull B bean2, @Nullable Object value) {
        ArgumentUtils.requireNonNull("bean", bean2);
        if (value != null) {
            Argument<T> argument = this.asArgument();
            ArgumentConversionContext<T> context = ConversionContext.of(argument);
            T converted = ConversionService.SHARED.convert(value, context).orElseThrow(() -> new ConversionErrorException(argument, context.getLastError().orElse(() -> new IllegalArgumentException("Value [" + value + "] cannot be converted to type : " + this.getType()))));
            this.set(bean2, converted);
        } else {
            this.set(bean2, value);
        }
    }

    @NonNull
    public Class<T> getType();

    @Override
    @NonNull
    default public Argument<T> asArgument() {
        return Argument.of(this.getType());
    }

    default public boolean isReadOnly() {
        return false;
    }

    default public boolean isWriteOnly() {
        return false;
    }

    default public boolean isReadWrite() {
        return !this.isReadOnly() && !this.isWriteOnly();
    }

    default public Class<B> getDeclaringType() {
        return this.getDeclaringBean().getBeanType();
    }
}

