/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.domain;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;

public class ConfigurationChangeResult
implements DataSerializable {
    private boolean isSuccessful = true;
    private String errorMessage;
    private Exception exception;
    private static final long serialVersionUID = 1L;

    public ConfigurationChangeResult() {
    }

    public ConfigurationChangeResult(boolean isSuccessful) {
        this.isSuccessful = isSuccessful;
    }

    public ConfigurationChangeResult(String errorMessage, Exception exception) {
        this.isSuccessful = false;
        this.errorMessage = errorMessage;
        this.exception = exception;
    }

    public void setIsSuccessful(boolean isSuccessful) {
        this.isSuccessful = isSuccessful;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
        result = 31 * result + (this.isSuccessful ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationChangeResult other = (ConfigurationChangeResult)obj;
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.exception == null ? other.exception != null : !this.exception.equals(other.exception)) {
            return false;
        }
        return this.isSuccessful == other.isSuccessful;
    }

    public String toString() {
        return "ConfigurationChangeResult [isSuccessful=" + this.isSuccessful + ", errorMessage=" + this.errorMessage + ", exception=" + this.exception + "]";
    }

    public void setException(Exception exception) {
        this.exception = exception;
        this.isSuccessful = false;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setErrorMessage(String errorMessage) {
        this.isSuccessful = false;
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeBoolean(this.isSuccessful, out);
        DataSerializer.writeString(this.errorMessage, out);
        DataSerializer.writeObject(this.exception, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.isSuccessful = DataSerializer.readBoolean(in);
        this.errorMessage = DataSerializer.readString(in);
        this.exception = (Exception)DataSerializer.readObject(in);
    }
}

