/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonLocalRegionEntry;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.Get70;
import org.apache.geode.internal.cache.versions.VersionTag;

public class GetEntry70
extends Get70 {
    @Immutable
    private static final GetEntry70 singleton = new GetEntry70();

    public static Command getCommand() {
        return singleton;
    }

    protected GetEntry70() {
    }

    @Override
    protected Get70.Entry getEntry(Region region, Object key, Object callbackArg, ServerConnection servConn) {
        return this.getValueAndIsObject(region, key, callbackArg, servConn);
    }

    @Override
    public Get70.Entry getValueAndIsObject(Region region, Object key, Object callbackArg, ServerConnection servConn) {
        LocalRegion lregion = (LocalRegion)region;
        EntrySnapshot data = null;
        Region.Entry entry = region.getEntry(key);
        if (logger.isDebugEnabled()) {
            logger.debug("GetEntryCommand: for key: {} returning entry: {}", key, entry);
        }
        VersionTag tag = null;
        if (entry != null) {
            EntrySnapshot snap = new EntrySnapshot();
            NonLocalRegionEntry re = new NonLocalRegionEntry(entry, lregion);
            snap.setRegionEntry(re);
            snap.setRegion(lregion);
            data = snap;
            tag = snap.getVersionTag();
        }
        return new Get70.Entry(data, true, false, tag);
    }
}

