/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.File;
import java.io.Serializable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreFactoryImpl;
import org.apache.geode.internal.cache.UserSpecifiedDiskStoreAttributes;

public class DiskStoreAttributesCreation
extends UserSpecifiedDiskStoreAttributes
implements Serializable,
DiskStore {
    public DiskStoreAttributesCreation() {
    }

    public DiskStoreAttributesCreation(DiskStoreAttributes attrs) {
        this.name = attrs.getName();
        this.autoCompact = attrs.getAutoCompact();
        this.compactionThreshold = attrs.getCompactionThreshold();
        this.allowForceCompaction = attrs.getAllowForceCompaction();
        this.maxOplogSizeInBytes = attrs.getMaxOplogSizeInBytes();
        this.timeInterval = attrs.getTimeInterval();
        this.writeBufferSize = attrs.getWriteBufferSize();
        this.queueSize = attrs.getQueueSize();
        this.diskDirs = attrs.getDiskDirs();
        this.diskDirSizes = attrs.getDiskDirSizes();
        this.setDiskUsageWarningPercentage(attrs.getDiskUsageWarningPercentage());
        this.setDiskUsageCriticalPercentage(attrs.getDiskUsageCriticalPercentage());
        if (attrs instanceof UserSpecifiedDiskStoreAttributes) {
            UserSpecifiedDiskStoreAttributes nonDefault = (UserSpecifiedDiskStoreAttributes)attrs;
            this.initHasFields(nonDefault);
        } else {
            this.setAllHasFields(true);
        }
    }

    static boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private boolean equal(long[] array1, long[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equal(int[] array1, int[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equal(File[] array1, File[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (File item : array1) {
            boolean found = false;
            for (File value : array2) {
                if (!DiskStoreAttributesCreation.equal(item.getAbsoluteFile(), value.getAbsoluteFile())) continue;
                found = true;
                break;
            }
            if (found) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Didn't find ");
            sb.append(item);
            sb.append(" in ");
            for (File file : array2) {
                sb.append(file);
                sb.append(" ");
            }
            System.out.println(sb);
            return false;
        }
        return true;
    }

    public boolean sameAs(DiskStore other) {
        if (this.autoCompact != other.getAutoCompact()) {
            throw new RuntimeException(String.format("AutoCompact of disk store %s is not the same: this: %s other: %s", this.name, this.autoCompact, other.getAutoCompact()));
        }
        if (this.compactionThreshold != other.getCompactionThreshold()) {
            throw new RuntimeException(String.format("CompactionThreshold of disk store %s is not the same: this: %s other: %s", this.name, this.compactionThreshold, other.getCompactionThreshold()));
        }
        if (this.allowForceCompaction != other.getAllowForceCompaction()) {
            throw new RuntimeException(String.format("AllowForceCompaction of disk store %s is not the same: this: %s other: %s", this.name, this.allowForceCompaction, other.getAllowForceCompaction()));
        }
        if (this.maxOplogSizeInBytes != other.getMaxOplogSize() * 1024L * 1024L) {
            throw new RuntimeException(String.format("MaxOpLogSize of disk store %s is not the same: this: %s other: %s", this.name, this.maxOplogSizeInBytes / 1024L / 1024L, other.getMaxOplogSize()));
        }
        if (this.timeInterval != other.getTimeInterval()) {
            throw new RuntimeException(String.format("TimeInterval of disk store %s is not the same: this: %s other: %s", this.name, this.timeInterval, other.getTimeInterval()));
        }
        if (this.writeBufferSize != other.getWriteBufferSize()) {
            throw new RuntimeException(String.format("WriteBufferSize of disk store %s is not the same: this: %s other: %s", this.name, this.writeBufferSize, other.getWriteBufferSize()));
        }
        if (this.queueSize != other.getQueueSize()) {
            throw new RuntimeException(String.format("QueueSize of disk store %s is not the same: this: %s other: %s", this.name, this.queueSize, other.getQueueSize()));
        }
        if (!this.equal(this.diskDirs, other.getDiskDirs())) {
            throw new RuntimeException(String.format("Disk Dirs of disk store %s are not the same", this.name));
        }
        if (!this.equal(this.diskDirSizes, other.getDiskDirSizes())) {
            throw new RuntimeException(String.format("Disk Dir Sizes of disk store %s are not the same", this.name));
        }
        if (!DiskStoreAttributesCreation.equal(Float.valueOf(this.getDiskUsageWarningPercentage()), Float.valueOf(other.getDiskUsageWarningPercentage()))) {
            throw new RuntimeException(String.format("Disk usage warning percentages of disk store %s are not the same", this.name));
        }
        if (!DiskStoreAttributesCreation.equal(Float.valueOf(this.getDiskUsageCriticalPercentage()), Float.valueOf(other.getDiskUsageCriticalPercentage()))) {
            throw new RuntimeException(String.format("Disk usage critical percentages of disk store %s are not the same", this.name));
        }
        return true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAutoCompact(boolean autoCompact) {
        this.autoCompact = autoCompact;
        this.setHasAutoCompact(true);
    }

    public void setCompactionThreshold(int compactionThreshold) {
        this.compactionThreshold = compactionThreshold;
        this.setHasCompactionThreshold(true);
    }

    public void setAllowForceCompaction(boolean allowForceCompaction) {
        this.allowForceCompaction = allowForceCompaction;
        this.setHasAllowForceCompaction(true);
    }

    public void setMaxOplogSize(long maxOplogSize) {
        this.maxOplogSizeInBytes = maxOplogSize * 1024L * 1024L;
        this.setHasMaxOplogSize(true);
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
        this.setHasTimeInterval(true);
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        this.setHasWriteBufferSize(true);
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        this.setHasQueueSize(true);
    }

    public void setDiskDirs(File[] diskDirs) {
        this.checkIfDirectoriesExist(diskDirs);
        this.diskDirs = diskDirs;
        this.diskDirSizes = new int[diskDirs.length];
        for (int i = 0; i < diskDirs.length; ++i) {
            this.diskDirSizes[i] = Integer.MAX_VALUE;
        }
        this.setHasDiskDirs(true);
    }

    public void setDiskDirsAndSize(File[] diskDirs, int[] sizes) {
        this.checkIfDirectoriesExist(diskDirs);
        this.diskDirs = diskDirs;
        if (sizes.length != this.diskDirs.length) {
            throw new IllegalArgumentException(String.format("Number of diskSizes is %s which is not equal to number of disk Dirs which is %s", sizes.length, diskDirs.length));
        }
        DiskStoreAttributesCreation.verifyNonNegativeDirSize(sizes);
        this.diskDirSizes = sizes;
        this.setHasDiskDirs(true);
    }

    @Override
    public void setDiskUsageWarningPercentage(float diskUsageWarningPercentage) {
        super.setDiskUsageWarningPercentage(diskUsageWarningPercentage);
        this.setHasDiskUsageWarningPercentage(true);
    }

    @Override
    public void setDiskUsageCriticalPercentage(float diskUsageCriticalPercentage) {
        super.setDiskUsageCriticalPercentage(diskUsageCriticalPercentage);
        this.setHasDiskUsageCriticalPercentage(true);
    }

    private void checkIfDirectoriesExist(File[] disk_dirs) {
        DiskStoreFactoryImpl.checkIfDirectoriesExist(disk_dirs);
    }
}

