/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Util;

public class LazyThreadFactory
extends DefaultThreadFactory {
    private final Collection<WeakReference<Thread>> threads = new ConcurrentLinkedQueue<WeakReference<Thread>>();
    private static final String ADDR = "<ADDR>";
    private static final String CLUSTER = "<CLUSTER>";

    public LazyThreadFactory(String baseName, boolean createDaemons, boolean use_numbering) {
        super(baseName, createDaemons, use_numbering);
    }

    @Override
    public Thread newThread(Runnable r, String name) {
        return this.newThread(null, r, name);
    }

    @Override
    public Thread newThread(Runnable r) {
        return this.newThread(null, r, this.baseName);
    }

    @Override
    public Thread newThread(ThreadGroup group, Runnable r, String name) {
        String cluster_name;
        Thread retval = null;
        String addr = this.address;
        if (addr == null) {
            addr = ADDR;
        }
        if ((cluster_name = this.clusterName) == null) {
            cluster_name = CLUSTER;
        }
        retval = super.newThread(r, name, addr, cluster_name);
        int size = this.threads.size();
        this.threads.add(new WeakReference<Thread>(retval));
        if (size > 0) {
            this.removeTerminatedThreads();
        }
        return retval;
    }

    @Override
    public void setAddress(String address) {
        boolean changed = false;
        if (!Util.match(this.address, address)) {
            changed = true;
        }
        super.setAddress(address);
        if (changed) {
            this.renameThreads();
        }
    }

    @Override
    public void setClusterName(String cluster_name) {
        boolean changed = false;
        if (!Util.match(this.clusterName, cluster_name)) {
            changed = true;
        }
        super.setClusterName(cluster_name);
        if (changed) {
            this.renameThreads();
        }
    }

    public int size() {
        return this.threads.size();
    }

    public void destroy() {
        this.threads.clear();
    }

    public void removeTerminatedThreads() {
        Iterator<WeakReference<Thread>> it = this.threads.iterator();
        while (it.hasNext()) {
            WeakReference<Thread> ref = it.next();
            Thread thread = (Thread)ref.get();
            if (thread != null && thread.getState() != Thread.State.TERMINATED) continue;
            it.remove();
        }
    }

    public String dumpThreads() {
        StringBuilder sb = new StringBuilder();
        int cnt = 1;
        for (WeakReference<Thread> ref : this.threads) {
            sb.append(String.format("ref %d: %s (%s)\n", new Object[]{cnt++, ref.get(), ((Thread)ref.get()).getState()}));
        }
        return sb.toString();
    }

    protected void renameThreads() {
        Iterator<WeakReference<Thread>> it = this.threads.iterator();
        while (it.hasNext()) {
            WeakReference<Thread> ref = it.next();
            Thread thread = (Thread)ref.get();
            if (thread == null || !thread.isAlive()) {
                it.remove();
                continue;
            }
            String name = thread.getName();
            name = this.changeName(name);
            thread.setName(name);
        }
    }

    protected String changeName(String name) {
        StringBuilder tmp;
        String retval = name;
        if (this.address != null) {
            tmp = new StringBuilder(this.address);
            retval = retval.replace(ADDR, tmp);
        }
        if (this.clusterName != null) {
            tmp = new StringBuilder(this.clusterName);
            retval = retval.replace(CLUSTER, tmp);
        }
        return retval;
    }
}

