/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.util.Strings;

public final class StringParameterParser {
    private StringParameterParser() {
    }

    public static Map<String, Value> parse(String input) {
        return StringParameterParser.parse(input, null);
    }

    public static Map<String, Value> parse(String input, Set<String> allowedKeys) {
        if (Strings.isBlank(input)) {
            return Collections.emptyMap();
        }
        Object map = new Parser(input).call();
        Set actualKeys = map.keySet();
        for (String actualKey : actualKeys) {
            boolean allowed = allowedKeys == null || allowedKeys.contains(actualKey);
            if (allowed) continue;
            String message = String.format("unknown key \"%s\" is found in input: %s", actualKey, input);
            throw new IllegalArgumentException(message);
        }
        return map;
    }

    private static final class Parser
    implements Callable<Map<String, Value>> {
        private final String input;
        private final Map<String, Value> map;
        private State state;
        private int i;
        private String key;

        private Parser(String input) {
            this.input = Objects.requireNonNull(input, "input");
            this.map = new LinkedHashMap<String, Value>();
            this.state = State.READING_KEY;
            this.i = 0;
            this.key = null;
        }

        @Override
        public Map<String, Value> call() {
            block6: {
                block4: while (true) {
                    this.skipWhitespace();
                    if (this.i >= this.input.length()) break block6;
                    switch (this.state) {
                        case READING_KEY: {
                            this.readKey();
                            continue block4;
                        }
                        case READING_VALUE: {
                            this.readValue();
                            continue block4;
                        }
                    }
                    break;
                }
                throw new IllegalStateException("unknown state: " + (Object)((Object)this.state));
            }
            if (this.state == State.READING_VALUE) {
                this.map.put(this.key, Values.nullValue());
            }
            return this.map;
        }

        private void readKey() {
            int j;
            int nextI;
            int eq = this.input.indexOf(61, this.i);
            int co = this.input.indexOf(44, this.i);
            if (eq < 0 && co < 0) {
                j = nextI = this.input.length();
            } else if (eq < 0) {
                j = nextI = co;
            } else if (co < 0) {
                j = eq;
                nextI = eq + 1;
            } else if (eq < co) {
                j = eq;
                nextI = eq + 1;
            } else {
                j = co;
                nextI = co;
            }
            this.key = this.input.substring(this.i, j).trim();
            if (Strings.isEmpty(this.key)) {
                String message = String.format("failed to locate key at index %d: %s", this.i, this.input);
                throw new IllegalArgumentException(message);
            }
            if (this.map.containsKey(this.key)) {
                String message = String.format("conflicting key at index %d: %s", this.i, this.input);
                throw new IllegalArgumentException(message);
            }
            this.state = State.READING_VALUE;
            this.i = nextI;
        }

        private void readValue() {
            boolean doubleQuoted;
            boolean bl = doubleQuoted = this.input.charAt(this.i) == '\"';
            if (doubleQuoted) {
                this.readDoubleQuotedStringValue();
            } else {
                this.readStringValue();
            }
            this.key = null;
            this.state = State.READING_KEY;
        }

        private void readDoubleQuotedStringValue() {
            int j;
            for (j = this.i + 1; j < this.input.length() && (this.input.charAt(j) != '\"' || this.input.charAt(j - 1) == '\\'); ++j) {
            }
            if (j >= this.input.length()) {
                String message = String.format("failed to locate the end of double-quoted content starting at index %d: %s", this.i, this.input);
                throw new IllegalArgumentException(message);
            }
            String content = this.input.substring(this.i + 1, j).replaceAll("\\\\\"", "\"");
            DoubleQuotedStringValue value = Values.doubleQuotedStringValue(content);
            this.map.put(this.key, value);
            this.i = j + 1;
            this.skipWhitespace();
            if (this.i < this.input.length()) {
                if (this.input.charAt(this.i) != ',') {
                    String message = String.format("was expecting comma at index %d: %s", this.i, this.input);
                    throw new IllegalArgumentException(message);
                }
                ++this.i;
            }
        }

        private void skipWhitespace() {
            char c;
            while (this.i < this.input.length() && Character.isWhitespace(c = this.input.charAt(this.i))) {
                ++this.i;
            }
        }

        private void readStringValue() {
            String content;
            String trimmedContent;
            int j = this.input.indexOf(44, this.i);
            if (j < 0) {
                j = this.input.length();
            }
            Value value = (trimmedContent = (content = this.input.substring(this.i, j)).trim()).isEmpty() ? Values.nullValue() : Values.stringValue(trimmedContent);
            this.map.put(this.key, value);
            this.i += content.length() + 1;
        }
    }

    private static enum State {
        READING_KEY,
        READING_VALUE;

    }

    public static final class DoubleQuotedStringValue
    implements Value {
        private final String doubleQuotedString;

        private DoubleQuotedStringValue(String doubleQuotedString) {
            this.doubleQuotedString = doubleQuotedString;
        }

        public String getDoubleQuotedString() {
            return this.doubleQuotedString;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DoubleQuotedStringValue that = (DoubleQuotedStringValue)object;
            return this.doubleQuotedString.equals(that.doubleQuotedString);
        }

        public int hashCode() {
            return 31 + Objects.hashCode(this.doubleQuotedString);
        }

        public String toString() {
            return this.doubleQuotedString.replaceAll("\\\\\"", "\"");
        }
    }

    public static final class StringValue
    implements Value {
        private final String string;

        private StringValue(String string) {
            this.string = string;
        }

        public String getString() {
            return this.string;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StringValue that = (StringValue)object;
            return this.string.equals(that.string);
        }

        public int hashCode() {
            return 31 + Objects.hashCode(this.string);
        }

        public String toString() {
            return this.string;
        }
    }

    public static final class NullValue
    implements Value {
        private static final NullValue INSTANCE = new NullValue();

        private NullValue() {
        }

        public String toString() {
            return "null";
        }
    }

    public static interface Value {
    }

    public static final class Values {
        private Values() {
        }

        static NullValue nullValue() {
            return NullValue.INSTANCE;
        }

        static StringValue stringValue(String string) {
            return new StringValue(string);
        }

        static DoubleQuotedStringValue doubleQuotedStringValue(String doubleQuotedString) {
            return new DoubleQuotedStringValue(doubleQuotedString);
        }
    }
}

