/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableReplaceIntersectWithSemiJoinRule;
import org.apache.flink.table.planner.plan.utils.SetOpRewriteUtil;
import org.immutables.value.Value;

@Value.Enclosing
public class ReplaceIntersectWithSemiJoinRule
extends RelRule<ReplaceIntersectWithSemiJoinRuleConfig> {
    public static final ReplaceIntersectWithSemiJoinRule INSTANCE = ReplaceIntersectWithSemiJoinRuleConfig.DEFAULT.toRule();

    private ReplaceIntersectWithSemiJoinRule(ReplaceIntersectWithSemiJoinRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Intersect intersect = (Intersect)call.rel(0);
        return !intersect.all && intersect.getInputs().size() == 2;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Intersect intersect = (Intersect)call.rel(0);
        RelNode left = intersect.getInput(0);
        RelNode right = intersect.getInput(1);
        RelBuilder relBuilder = call.builder();
        List<Integer> keys = Util.range(left.getRowType().getFieldCount());
        List<RexNode> conditions = SetOpRewriteUtil.generateEqualsCondition(relBuilder, left, right, keys);
        relBuilder.push(left);
        relBuilder.push(right);
        relBuilder.join(JoinRelType.SEMI, conditions).aggregate(relBuilder.groupKey(keys.stream().mapToInt(Integer::intValue).toArray()), new RelBuilder.AggCall[0]);
        RelNode rel = relBuilder.build();
        call.transformTo(rel);
    }

    @Value.Immutable(singleton=false)
    public static interface ReplaceIntersectWithSemiJoinRuleConfig
    extends RelRule.Config {
        public static final ReplaceIntersectWithSemiJoinRuleConfig DEFAULT = ImmutableReplaceIntersectWithSemiJoinRule.ReplaceIntersectWithSemiJoinRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(Intersect.class).anyInputs()).withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withDescription("ReplaceIntersectWithSemiJoinRule");

        @Override
        default public ReplaceIntersectWithSemiJoinRule toRule() {
            return new ReplaceIntersectWithSemiJoinRule(this);
        }
    }
}

