/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.shaded.curator5.org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableEventTimeTemporalJoinRewriteRule;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.planner.plan.utils.TemporalTableJoinUtil;
import org.immutables.value.Value;

@Value.Enclosing
public class EventTimeTemporalJoinRewriteRule
extends RelRule<Config> {
    public static final RuleSet EVENT_TIME_TEMPORAL_JOIN_REWRITE_RULES = RuleSets.ofList(Config.JOIN_CALC_SNAPSHOT_CALC_WMA_CALC_TS.toRule(), Config.JOIN_CALC_SNAPSHOT_CALC_WMA_TS.toRule(), Config.JOIN_CALC_SNAPSHOT_WMA_CALC_TS.toRule(), Config.JOIN_CALC_SNAPSHOT_WMA_TS.toRule(), Config.JOIN_SNAPSHOT_CALC_WMA_CALC_TS.toRule(), Config.JOIN_SNAPSHOT_CALC_WMA_TS.toRule(), Config.JOIN_SNAPSHOT_WMA_CALC_TS.toRule(), Config.JOIN_SNAPSHOT_WMA_TS.toRule());

    public EventTimeTemporalJoinRewriteRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalJoin join = (FlinkLogicalJoin)call.rel(0);
        RexNode joinCondition = join.getCondition();
        return joinCondition != null && TemporalTableJoinUtil.isEventTimeTemporalJoin(joinCondition);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FlinkLogicalJoin join = (FlinkLogicalJoin)call.rel(0);
        FlinkLogicalRel joinRightChild = (FlinkLogicalRel)call.rel(2);
        RelNode newRight = this.transmitSnapshotRequirement(joinRightChild);
        call.transformTo(join.copy(join.getTraitSet(), (List)Lists.newArrayList((Object[])new RelNode[]{join.getLeft(), newRight})));
    }

    private RelNode transmitSnapshotRequirement(RelNode node) {
        if (node instanceof FlinkLogicalCalc) {
            FlinkLogicalCalc calc = (FlinkLogicalCalc)node;
            if (null != calc.getProgram().getCondition()) {
                throw new TableException("Filter is not allowed for right changelog input of event time temporal join, it will corrupt the versioning of data. Please consider removing the filter before joining.");
            }
            RelNode child = calc.getInput();
            RelNode newChild = this.transmitSnapshotRequirement(child);
            if (newChild != child) {
                return calc.copy(calc.getTraitSet(), newChild, calc.getProgram());
            }
            return calc;
        }
        if (node instanceof FlinkLogicalSnapshot) {
            FlinkLogicalSnapshot snapshot = (FlinkLogicalSnapshot)node;
            assert (this.isEventTime(snapshot.getPeriod().getType()));
            RelNode child = snapshot.getInput();
            RelNode newChild = this.transmitSnapshotRequirement(child);
            if (newChild != child) {
                return snapshot.copy(snapshot.getTraitSet(), newChild, snapshot.getPeriod());
            }
            return snapshot;
        }
        if (node instanceof HepRelVertex) {
            return this.transmitSnapshotRequirement(((HepRelVertex)node).getCurrentRel());
        }
        if (node instanceof FlinkLogicalWatermarkAssigner) {
            FlinkLogicalWatermarkAssigner wma = (FlinkLogicalWatermarkAssigner)node;
            RelNode child = wma.getInput();
            RelNode newChild = this.transmitSnapshotRequirement(child);
            if (newChild != child) {
                return wma.copy(wma.getTraitSet(), newChild, wma.getHints(), wma.rowtimeFieldIndex(), wma.watermarkExpr());
            }
            return wma;
        }
        if (node instanceof FlinkLogicalTableSourceScan) {
            FlinkLogicalTableSourceScan ts = (FlinkLogicalTableSourceScan)node;
            return ts.copy(ts.getTraitSet(), ts.relOptTable(), true);
        }
        return node;
    }

    private boolean isEventTime(RelDataType period) {
        if (period instanceof TimeIndicatorRelDataType) {
            return ((TimeIndicatorRelDataType)period).isEventTime();
        }
        return false;
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final RelRule.Config JOIN_CALC_SNAPSHOT_CALC_WMA_CALC_TS = ImmutableEventTimeTemporalJoinRewriteRule.Config.builder().build().withDescription("EventTimeTemporalJoinRewriteRule_CALC_SNAPSHOT_CALC_WMA_CALC").as(Config.class).withOperandSupplier(joinTransform -> joinTransform.operand(FlinkLogicalJoin.class).inputs(left -> left.operand(FlinkLogicalRel.class).anyInputs(), right -> right.operand(FlinkLogicalCalc.class).oneInput(r1 -> r1.operand(FlinkLogicalSnapshot.class).oneInput(r2 -> r2.operand(FlinkLogicalCalc.class).oneInput(r3 -> r3.operand(FlinkLogicalWatermarkAssigner.class).oneInput(r4 -> r4.operand(FlinkLogicalCalc.class).oneInput(r5 -> r5.operand(FlinkLogicalTableSourceScan.class).noInputs())))))));
        public static final RelRule.Config JOIN_CALC_SNAPSHOT_CALC_WMA_TS = ImmutableEventTimeTemporalJoinRewriteRule.Config.builder().build().withDescription("EventTimeTemporalJoinRewriteRule_CALC_SNAPSHOT_CALC_WMA").as(Config.class).withOperandSupplier(joinTransform -> joinTransform.operand(FlinkLogicalJoin.class).inputs(left -> left.operand(FlinkLogicalRel.class).anyInputs(), right -> right.operand(FlinkLogicalCalc.class).oneInput(r1 -> r1.operand(FlinkLogicalSnapshot.class).oneInput(r2 -> r2.operand(FlinkLogicalCalc.class).oneInput(r3 -> r3.operand(FlinkLogicalWatermarkAssigner.class).oneInput(r4 -> r4.operand(FlinkLogicalTableSourceScan.class).noInputs()))))));
        public static final RelRule.Config JOIN_CALC_SNAPSHOT_WMA_CALC_TS = ImmutableEventTimeTemporalJoinRewriteRule.Config.builder().build().withDescription("EventTimeTemporalJoinRewriteRule_CALC_SNAPSHOT_WMA_CALC").as(Config.class).withOperandSupplier(joinTransform -> joinTransform.operand(FlinkLogicalJoin.class).inputs(left -> left.operand(FlinkLogicalRel.class).anyInputs(), right -> right.operand(FlinkLogicalCalc.class).oneInput(r1 -> r1.operand(FlinkLogicalSnapshot.class).oneInput(r2 -> r2.operand(FlinkLogicalWatermarkAssigner.class).oneInput(r3 -> r3.operand(FlinkLogicalCalc.class).oneInput(r4 -> r4.operand(FlinkLogicalTableSourceScan.class).noInputs()))))));
        public static final RelRule.Config JOIN_CALC_SNAPSHOT_WMA_TS = ImmutableEventTimeTemporalJoinRewriteRule.Config.builder().build().withDescription("EventTimeTemporalJoinRewriteRule_CALC_SNAPSHOT_WMA").as(Config.class).withOperandSupplier(joinTransform -> joinTransform.operand(FlinkLogicalJoin.class).inputs(left -> left.operand(FlinkLogicalRel.class).anyInputs(), right -> right.operand(FlinkLogicalCalc.class).oneInput(r1 -> r1.operand(FlinkLogicalSnapshot.class).oneInput(r2 -> r2.operand(FlinkLogicalWatermarkAssigner.class).oneInput(r3 -> r3.operand(FlinkLogicalTableSourceScan.class).noInputs())))));
        public static final RelRule.Config JOIN_SNAPSHOT_CALC_WMA_CALC_TS = ImmutableEventTimeTemporalJoinRewriteRule.Config.builder().build().withDescription("EventTimeTemporalJoinRewriteRule_SNAPSHOT_CALC_WMA_CALC").as(Config.class).withOperandSupplier(joinTransform -> joinTransform.operand(FlinkLogicalJoin.class).inputs(left -> left.operand(FlinkLogicalRel.class).anyInputs(), right -> right.operand(FlinkLogicalSnapshot.class).oneInput(r1 -> r1.operand(FlinkLogicalCalc.class).oneInput(r2 -> r2.operand(FlinkLogicalWatermarkAssigner.class).oneInput(r3 -> r3.operand(FlinkLogicalCalc.class).oneInput(r4 -> r4.operand(FlinkLogicalTableSourceScan.class).noInputs()))))));
        public static final RelRule.Config JOIN_SNAPSHOT_CALC_WMA_TS = ImmutableEventTimeTemporalJoinRewriteRule.Config.builder().build().withDescription("EventTimeTemporalJoinRewriteRule_SNAPSHOT_CALC_WMA").as(Config.class).withOperandSupplier(joinTransform -> joinTransform.operand(FlinkLogicalJoin.class).inputs(left -> left.operand(FlinkLogicalRel.class).anyInputs(), right -> right.operand(FlinkLogicalSnapshot.class).oneInput(r1 -> r1.operand(FlinkLogicalCalc.class).oneInput(r2 -> r2.operand(FlinkLogicalWatermarkAssigner.class).oneInput(r3 -> r3.operand(FlinkLogicalTableSourceScan.class).noInputs())))));
        public static final RelRule.Config JOIN_SNAPSHOT_WMA_CALC_TS = ImmutableEventTimeTemporalJoinRewriteRule.Config.builder().build().withDescription("EventTimeTemporalJoinRewriteRule_SNAPSHOT_WMA_CALC").as(Config.class).withOperandSupplier(joinTransform -> joinTransform.operand(FlinkLogicalJoin.class).inputs(left -> left.operand(FlinkLogicalRel.class).anyInputs(), right -> right.operand(FlinkLogicalSnapshot.class).oneInput(r1 -> r1.operand(FlinkLogicalWatermarkAssigner.class).oneInput(r2 -> r2.operand(FlinkLogicalCalc.class).oneInput(r3 -> r3.operand(FlinkLogicalTableSourceScan.class).noInputs())))));
        public static final RelRule.Config JOIN_SNAPSHOT_WMA_TS = ImmutableEventTimeTemporalJoinRewriteRule.Config.builder().build().withDescription("EventTimeTemporalJoinRewriteRule_SNAPSHOT_WMA").as(Config.class).withOperandSupplier(joinTransform -> joinTransform.operand(FlinkLogicalJoin.class).inputs(left -> left.operand(FlinkLogicalRel.class).anyInputs(), right -> right.operand(FlinkLogicalSnapshot.class).oneInput(r1 -> r1.operand(FlinkLogicalWatermarkAssigner.class).oneInput(r2 -> r2.operand(FlinkLogicalTableSourceScan.class).noInputs()))));

        @Override
        default public RelOptRule toRule() {
            return new EventTimeTemporalJoinRewriteRule(this);
        }
    }
}

