/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import java.util.Collections;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.jdbc.JdbcToEnumerableConverter;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;

public class ToLogicalConverter
extends RelShuttleImpl {
    private final RelBuilder relBuilder;

    public ToLogicalConverter(RelBuilder relBuilder) {
        this.relBuilder = relBuilder;
    }

    @Override
    public RelNode visit(TableScan scan) {
        return LogicalTableScan.create(scan.getCluster(), scan.getTable(), scan.getHints());
    }

    @Override
    public RelNode visit(RelNode relNode) {
        if (relNode instanceof Aggregate) {
            Aggregate agg = (Aggregate)relNode;
            return this.relBuilder.push(this.visit(agg.getInput())).aggregate(this.relBuilder.groupKey(agg.getGroupSet(), (Iterable<? extends ImmutableBitSet>)agg.groupSets), agg.getAggCallList()).build();
        }
        if (relNode instanceof TableScan) {
            return this.visit((TableScan)relNode);
        }
        if (relNode instanceof Filter) {
            Filter filter = (Filter)relNode;
            return this.relBuilder.push(this.visit(filter.getInput())).filter(filter.getCondition()).build();
        }
        if (relNode instanceof Project) {
            Project project = (Project)relNode;
            return this.relBuilder.push(this.visit(project.getInput())).project(project.getProjects(), project.getRowType().getFieldNames()).build();
        }
        if (relNode instanceof Union) {
            Union union = (Union)relNode;
            for (RelNode rel : union.getInputs()) {
                this.relBuilder.push(this.visit(rel));
            }
            return this.relBuilder.union(union.all, union.getInputs().size()).build();
        }
        if (relNode instanceof Intersect) {
            Intersect intersect = (Intersect)relNode;
            for (RelNode rel : intersect.getInputs()) {
                this.relBuilder.push(this.visit(rel));
            }
            return this.relBuilder.intersect(intersect.all, intersect.getInputs().size()).build();
        }
        if (relNode instanceof Minus) {
            Minus minus = (Minus)relNode;
            for (RelNode rel : minus.getInputs()) {
                this.relBuilder.push(this.visit(rel));
            }
            return this.relBuilder.minus(minus.all, minus.getInputs().size()).build();
        }
        if (relNode instanceof Join) {
            Join join = (Join)relNode;
            return this.relBuilder.push(this.visit(join.getLeft())).push(this.visit(join.getRight())).join(join.getJoinType(), join.getCondition()).build();
        }
        if (relNode instanceof Correlate) {
            Correlate corr = (Correlate)relNode;
            return this.relBuilder.push(this.visit(corr.getLeft())).push(this.visit(corr.getRight())).join(corr.getJoinType(), (RexNode)this.relBuilder.literal(true), corr.getVariablesSet()).build();
        }
        if (relNode instanceof Values) {
            Values values = (Values)relNode;
            return this.relBuilder.values(values.tuples, values.getRowType()).build();
        }
        if (relNode instanceof Sort) {
            Sort sort = (Sort)relNode;
            return LogicalSort.create(this.visit(sort.getInput()), sort.getCollation(), sort.offset, sort.fetch);
        }
        if (relNode instanceof Window) {
            Window window = (Window)relNode;
            RelNode input = this.visit(window.getInput());
            return LogicalWindow.create(input.getTraitSet(), input, window.constants, window.getRowType(), window.groups);
        }
        if (relNode instanceof Calc) {
            Calc calc = (Calc)relNode;
            return LogicalCalc.create(this.visit(calc.getInput()), calc.getProgram());
        }
        if (relNode instanceof TableModify) {
            TableModify tableModify = (TableModify)relNode;
            RelNode input = this.visit(tableModify.getInput());
            return LogicalTableModify.create(tableModify.getTable(), tableModify.getCatalogReader(), input, tableModify.getOperation(), tableModify.getUpdateColumnList(), tableModify.getSourceExpressionList(), tableModify.isFlattened());
        }
        if (relNode instanceof EnumerableInterpreter || relNode instanceof JdbcToEnumerableConverter) {
            return this.visit(((SingleRel)relNode).getInput());
        }
        if (relNode instanceof EnumerableLimit) {
            EnumerableLimit limit = (EnumerableLimit)relNode;
            RelNode logicalInput = this.visit(limit.getInput());
            RelCollation collation = RelCollations.of(new RelFieldCollation[0]);
            if (logicalInput instanceof Sort) {
                collation = ((Sort)logicalInput).collation;
                logicalInput = ((Sort)logicalInput).getInput();
            }
            return LogicalSort.create(logicalInput, collation, limit.offset, limit.fetch);
        }
        if (relNode instanceof Uncollect) {
            Uncollect uncollect = (Uncollect)relNode;
            RelNode input = this.visit(uncollect.getInput());
            return Uncollect.create(input.getTraitSet(), input, uncollect.withOrdinality, Collections.emptyList());
        }
        throw new AssertionError((Object)("Need to implement logical converter for " + relNode.getClass().getName()));
    }
}

