/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream;

import java.util.ArrayList;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.functions.sink.filesystem.Bucket;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketLifeCycleListener;
import org.apache.flink.streaming.api.functions.sink.filesystem.Buckets;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSinkHelper;
import org.apache.flink.streaming.api.functions.sink.filesystem.legacy.StreamingFileSink;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

public abstract class AbstractStreamingWriter<IN, OUT>
extends AbstractStreamOperator<OUT>
implements OneInputStreamOperator<IN, OUT>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final long bucketCheckInterval;
    private final StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder;
    protected transient Buckets<IN, String> buckets;
    private transient StreamingFileSinkHelper<IN> helper;
    protected transient long currentWatermark;
    private static final ListStateDescriptor<Boolean> END_OF_INPUT_STATE_DESC = new ListStateDescriptor("end_of_input_state", (TypeSerializer)BooleanSerializer.INSTANCE);
    private boolean endOfInput;
    private ListState<Boolean> endOfInputState;

    public AbstractStreamingWriter(long bucketCheckInterval, StreamingFileSink.BucketsBuilder<IN, String, ? extends StreamingFileSink.BucketsBuilder<IN, String, ?>> bucketsBuilder) {
        this.bucketCheckInterval = bucketCheckInterval;
        this.bucketsBuilder = bucketsBuilder;
    }

    protected abstract void partitionCreated(String var1);

    protected abstract void partitionInactive(String var1);

    protected abstract void onPartFileOpened(String var1, Path var2);

    protected void commitUpToCheckpoint(long checkpointId) throws Exception {
        this.helper.commitUpToCheckpoint(checkpointId);
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.buckets = this.bucketsBuilder.createBuckets(this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask());
        this.buckets.setBucketLifeCycleListener(new BucketLifeCycleListener<IN, String>(){

            public void bucketCreated(Bucket<IN, String> bucket) {
                AbstractStreamingWriter.this.partitionCreated((String)bucket.getBucketId());
            }

            public void bucketInactive(Bucket<IN, String> bucket) {
                AbstractStreamingWriter.this.partitionInactive((String)bucket.getBucketId());
            }
        });
        this.buckets.setFileLifeCycleListener(this::onPartFileOpened);
        this.helper = new StreamingFileSinkHelper(this.buckets, context.isRestored(), context.getOperatorStateStore(), this.getRuntimeContext().getProcessingTimeService(), this.bucketCheckInterval);
        this.currentWatermark = Long.MIN_VALUE;
        this.endOfInputState = context.getOperatorStateStore().getListState(END_OF_INPUT_STATE_DESC);
        ArrayList previousState = Lists.newArrayList((Iterable)((Iterable)this.endOfInputState.get()));
        this.endOfInput = !previousState.isEmpty() && !previousState.contains(false);
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.helper.snapshotState(context.getCheckpointId());
    }

    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        Preconditions.checkState((!this.endOfInput ? 1 : 0) != 0, (String)"Received element after endOfInput: %s", (Object[])new Object[]{element});
        this.helper.onElement(element.getValue(), this.getProcessingTimeService().getCurrentProcessingTime(), element.hasTimestamp() ? Long.valueOf(element.getTimestamp()) : null, this.currentWatermark);
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        super.notifyCheckpointComplete(checkpointId);
        if (!this.endOfInput) {
            this.commitUpToCheckpoint(checkpointId);
        }
    }

    public void endInput() throws Exception {
        if (!this.endOfInput) {
            this.endOfInput = true;
            this.buckets.onProcessingTime(Long.MAX_VALUE);
            this.helper.snapshotState(Long.MAX_VALUE);
            this.output.emitWatermark(new Watermark(Long.MAX_VALUE));
            this.commitUpToCheckpoint(Long.MAX_VALUE);
        }
    }

    public void close() throws Exception {
        super.close();
        if (this.helper != null) {
            this.helper.close();
        }
    }
}

