/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.lang.reflect.Method;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class DecimalToNumericPrimitiveCastRule
extends AbstractExpressionCodeGeneratorCastRule<DecimalData, Number> {
    static final DecimalToNumericPrimitiveCastRule INSTANCE = new DecimalToNumericPrimitiveCastRule();

    private DecimalToNumericPrimitiveCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.DECIMAL).target(LogicalTypeFamily.INTEGER_NUMERIC).target(LogicalTypeFamily.APPROXIMATE_NUMERIC).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        Method method = targetLogicalType.is(LogicalTypeFamily.INTEGER_NUMERIC) ? BuiltInMethods.DECIMAL_TO_INTEGRAL() : BuiltInMethods.DECIMAL_TO_DOUBLE();
        return CastRuleUtils.castToPrimitive(targetLogicalType, CastRuleUtils.staticCall(method, inputTerm));
    }
}

