/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.JsonType;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;

@Internal
class IsJsonConverter
extends CustomizedConverter {
    IsJsonConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        IsJsonConverter.checkArgumentNumber(call, 1, 2);
        JsonType type = call.getChildren().size() >= 2 ? this.getJsonTypeArgument(call) : JsonType.VALUE;
        return context.getRelBuilder().call(this.getOperator(type), context.toRexNode((Expression)call.getChildren().get(0)));
    }

    private JsonType getJsonTypeArgument(CallExpression call) {
        return (JsonType)((ValueLiteralExpression)call.getChildren().get(1)).getValueAs(JsonType.class).orElseThrow(() -> new TableException(String.format("Expected argument of type '%s'.", JsonType.class.getSimpleName())));
    }

    private SqlOperator getOperator(JsonType type) {
        switch (type) {
            case VALUE: {
                return FlinkSqlOperatorTable.IS_JSON_VALUE;
            }
            case SCALAR: {
                return FlinkSqlOperatorTable.IS_JSON_SCALAR;
            }
            case ARRAY: {
                return FlinkSqlOperatorTable.IS_JSON_ARRAY;
            }
            case OBJECT: {
                return FlinkSqlOperatorTable.IS_JSON_OBJECT;
            }
        }
        throw new TableException(String.format("Unknown JSON type '%s'.", type));
    }
}

