/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.calcite.adapter.enumerable.AggImpState;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.enumerable.WinAggContext;
import org.apache.calcite.adapter.enumerable.WinAggFrameResultContext;
import org.apache.calcite.adapter.enumerable.WinAggImplementor;
import org.apache.calcite.adapter.enumerable.impl.WinAggAddContextImpl;
import org.apache.calcite.adapter.enumerable.impl.WinAggResetContextImpl;
import org.apache.calcite.adapter.enumerable.impl.WinAggResultContextImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.DeclarationStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.runtime.SortedMultiMap;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableWindow
extends Window
implements EnumerableRel {
    EnumerableWindow(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
        super(cluster, traits, child, constants, rowType, groups);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableWindow(this.getCluster(), traitSet, EnumerableWindow.sole(inputs), this.constants, this.getRowType(), this.groups);
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = super.computeSelfCost(planner, mq);
        if (cost == null) {
            return null;
        }
        return cost.multiplyBy(1.0);
    }

    private static void sampleOfTheGeneratedWindowedAggregate() {
        Iterator iterator = null;
        Integer[] rows = (Integer[])iterator.next();
        int prevStart = -1;
        int prevEnd = -1;
        for (int i = 0; i < rows.length; ++i) {
            Integer row = rows[i];
            int start = 0;
            int end = 100;
            if (start == prevStart && end == prevEnd) continue;
            int actualStart = 0;
            actualStart = start != prevStart || end < prevEnd ? start : prevEnd + 1;
            prevStart = start;
            prevEnd = end;
            if (start == -1) continue;
            for (int j = actualStart; j <= end; ++j) {
            }
        }
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        EnumerableRel child = (EnumerableRel)this.getInput();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        Expression source_ = builder.append("source", result.block);
        ArrayList<Expression> translatedConstants = new ArrayList<Expression>(this.constants.size());
        for (RexLiteral constant : this.constants) {
            translatedConstants.add(RexToLixTranslator.translateLiteral(constant, constant.getType(), typeFactory, RexImpTable.NullAs.NULL));
        }
        PhysType inputPhysType = result.physType;
        ParameterExpression prevStart = Expressions.parameter(Integer.TYPE, builder.newName("prevStart"));
        ParameterExpression prevEnd = Expressions.parameter(Integer.TYPE, builder.newName("prevEnd"));
        builder.add(Expressions.declare(0, prevStart, null));
        builder.add(Expressions.declare(0, prevEnd, null));
        for (int windowIdx = 0; windowIdx < this.groups.size(); ++windowIdx) {
            Expression hasRows;
            Expression endX;
            Expression startX;
            Window.Group group = (Window.Group)this.groups.get(windowIdx);
            Expression comparator_ = builder.append("comparator", inputPhysType.generateComparator(group.collation()));
            Pair<Expression, Expression> partitionIterator = EnumerableWindow.getPartitionIterator(builder, source_, inputPhysType, group, comparator_);
            Expression collectionExpr = (Expression)partitionIterator.left;
            Expression iterator_ = (Expression)partitionIterator.right;
            ArrayList<AggImpState> aggs = new ArrayList<AggImpState>();
            List<AggregateCall> aggregateCalls = group.getAggregateCalls(this);
            for (int aggIdx = 0; aggIdx < aggregateCalls.size(); ++aggIdx) {
                AggregateCall call = aggregateCalls.get(aggIdx);
                if (call.ignoreNulls()) {
                    throw new UnsupportedOperationException("IGNORE NULLS not supported");
                }
                aggs.add(new AggImpState(aggIdx, call, true));
            }
            RelDataTypeFactory.FieldInfoBuilder typeBuilder = typeFactory.builder();
            ((RelDataTypeFactory.Builder)typeBuilder).addAll(inputPhysType.getRowType().getFieldList());
            for (AggImpState agg2 : aggs) {
                String name = Objects.requireNonNull(agg2.call.name, () -> "agg.call.name for " + agg.call);
                ((RelDataTypeFactory.Builder)typeBuilder).add(name, agg2.call.type);
            }
            RelDataType outputRowType = typeBuilder.build();
            PhysType outputPhysType = PhysTypeImpl.of(typeFactory, outputRowType, pref.prefer(result.format));
            Expression list_ = builder.append("list", Expressions.new_(ArrayList.class, new Expression[]{Expressions.call(collectionExpr, BuiltInMethod.COLLECTION_SIZE.method, new Expression[0])}), false);
            Pair<@Nullable Expression, @Nullable Expression> collationKey = EnumerableWindow.getRowCollationKey(builder, inputPhysType, group, windowIdx);
            Expression keySelector = (Expression)collationKey.left;
            Expression keyComparator = (Expression)collationKey.right;
            BlockBuilder builder3 = new BlockBuilder();
            Expression rows_ = builder3.append("rows", Expressions.convert_(Expressions.call(iterator_, BuiltInMethod.ITERATOR_NEXT.method, new Expression[0]), Object[].class), false);
            builder3.add(Expressions.statement(Expressions.assign(prevStart, Expressions.constant(-1))));
            builder3.add(Expressions.statement(Expressions.assign(prevEnd, Expressions.constant(Integer.MAX_VALUE))));
            BlockBuilder builder4 = new BlockBuilder();
            ParameterExpression i_ = Expressions.parameter(Integer.TYPE, builder4.newName("i"));
            Expression row_ = builder4.append("row", EnumUtils.convert(Expressions.arrayIndex(rows_, i_), inputPhysType.getJavaRowType()));
            WindowRelInputGetter inputGetter = new WindowRelInputGetter(row_, inputPhysType, result.physType.getRowType().getFieldCount(), translatedConstants);
            RexToLixTranslator translator = RexToLixTranslator.forAggregation(typeFactory, builder4, inputGetter, implementor.getConformance());
            ArrayList<Expression> outputRow = new ArrayList<Expression>();
            int fieldCountWithAggResults = inputPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCountWithAggResults; ++i) {
                outputRow.add(inputPhysType.fieldReference(row_, i, outputPhysType.getJavaFieldType(i)));
            }
            this.declareAndResetState(typeFactory, builder, result, windowIdx, aggs, outputPhysType, outputRow);
            ConstantExpression minX = Expressions.constant(0);
            Expression partitionRowCount = builder3.append("partRows", Expressions.field(rows_, "length"));
            Expression maxX = builder3.append("maxX", Expressions.subtract(partitionRowCount, Expressions.constant(1)));
            Expression startUnchecked = builder4.append("start", EnumerableWindow.translateBound(translator, i_, row_, minX, maxX, rows_, group, true, inputPhysType, keySelector, keyComparator));
            Expression endUnchecked = builder4.append("end", EnumerableWindow.translateBound(translator, i_, row_, minX, maxX, rows_, group, false, inputPhysType, keySelector, keyComparator));
            if (group.isAlwaysNonEmpty()) {
                startX = startUnchecked;
                endX = endUnchecked;
                hasRows = Expressions.constant(true);
            } else {
                Expression startTmp = group.lowerBound.isUnbounded() || startUnchecked == i_ ? startUnchecked : builder4.append("startTmp", Expressions.call(null, BuiltInMethod.MATH_MAX.method, startUnchecked, minX));
                Expression endTmp = group.upperBound.isUnbounded() || endUnchecked == i_ ? endUnchecked : builder4.append("endTmp", Expressions.call(null, BuiltInMethod.MATH_MIN.method, endUnchecked, maxX));
                ParameterExpression startPe = Expressions.parameter(0, Integer.TYPE, builder4.newName("startChecked"));
                ParameterExpression endPe = Expressions.parameter(0, Integer.TYPE, builder4.newName("endChecked"));
                builder4.add(Expressions.declare(16, startPe, null));
                builder4.add(Expressions.declare(16, endPe, null));
                hasRows = builder4.append("hasRows", Expressions.lessThanOrEqual(startTmp, endTmp));
                builder4.add(Expressions.ifThenElse(hasRows, (Node)Expressions.block(Expressions.statement(Expressions.assign(startPe, startTmp)), Expressions.statement(Expressions.assign(endPe, endTmp))), (Node)Expressions.block(Expressions.statement(Expressions.assign(startPe, Expressions.constant(-1))), Expressions.statement(Expressions.assign(endPe, Expressions.constant(-1))))));
                startX = startPe;
                endX = endPe;
            }
            BlockBuilder builder5 = new BlockBuilder(true, builder4);
            BinaryExpression rowCountWhenNonEmpty = Expressions.add(startX == minX ? endX : Expressions.subtract(endX, startX), Expressions.constant(1));
            Expression frameRowCount = hasRows.equals(Expressions.constant(true)) ? builder4.append("totalRows", rowCountWhenNonEmpty) : builder4.append("totalRows", Expressions.condition(hasRows, rowCountWhenNonEmpty, Expressions.constant(0)));
            ParameterExpression actualStart = Expressions.parameter(0, Integer.TYPE, builder5.newName("actualStart"));
            BlockBuilder builder6 = new BlockBuilder(true, builder5);
            builder6.add(Expressions.statement(Expressions.assign(actualStart, startX)));
            for (AggImpState agg3 : aggs) {
                List<Expression> aggState = Objects.requireNonNull(agg3.state, "agg.state");
                agg3.implementor.implementReset(Objects.requireNonNull(agg3.context, "agg.context"), new WinAggResetContextImpl(builder6, aggState, i_, startX, endX, hasRows, frameRowCount, partitionRowCount));
            }
            BinaryExpression lowerBoundCanChange = group.lowerBound.isUnbounded() && group.lowerBound.isPreceding() ? Expressions.constant(false) : Expressions.notEqual(startX, prevStart);
            BinaryExpression needRecomputeWindow = Expressions.orElse(lowerBoundCanChange, Expressions.lessThan(endX, prevEnd));
            BlockStatement resetWindowState = builder6.toBlock();
            if (resetWindowState.statements.size() == 1) {
                builder5.add(Expressions.declare(0, actualStart, Expressions.condition(needRecomputeWindow, startX, Expressions.add(prevEnd, Expressions.constant(1)))));
            } else {
                builder5.add(Expressions.declare(0, actualStart, null));
                builder5.add(Expressions.ifThenElse((Expression)needRecomputeWindow, (Node)resetWindowState, (Node)Expressions.statement(Expressions.assign(actualStart, Expressions.add(prevEnd, Expressions.constant(1))))));
            }
            if (lowerBoundCanChange instanceof BinaryExpression) {
                builder5.add(Expressions.statement(Expressions.assign(prevStart, startX)));
            }
            builder5.add(Expressions.statement(Expressions.assign(prevEnd, endX)));
            BlockBuilder builder7 = new BlockBuilder(true, builder5);
            DeclarationStatement jDecl = Expressions.declare(0, "j", (Expression)actualStart);
            PhysType inputPhysTypeFinal = inputPhysType;
            Function<BlockBuilder, WinAggFrameResultContext> resultContextBuilder = EnumerableWindow.getBlockBuilderWinAggFrameResultContextFunction(typeFactory, implementor.getConformance(), result, translatedConstants, comparator_, rows_, i_, startX, endX, minX, maxX, hasRows, frameRowCount, partitionRowCount, jDecl, inputPhysTypeFinal);
            Function<AggImpState, List<RexNode>> rexArguments = agg -> {
                List<Integer> argList = agg.call.getArgList();
                List<RelDataType> inputTypes = EnumUtils.fieldRowTypes(result.physType.getRowType(), this.constants, argList);
                ArrayList<RexInputRef> args = new ArrayList<RexInputRef>(inputTypes.size());
                for (int i = 0; i < argList.size(); ++i) {
                    Integer idx = argList.get(i);
                    args.add(new RexInputRef(idx, inputTypes.get(i)));
                }
                return args;
            };
            EnumerableWindow.implementAdd(aggs, builder7, resultContextBuilder, rexArguments, jDecl);
            BlockStatement forBlock = builder7.toBlock();
            if (!forBlock.statements.isEmpty()) {
                Statement forAggLoop = Expressions.for_(Arrays.asList(jDecl), (Expression)Expressions.lessThanOrEqual(jDecl.parameter, endX), (Expression)Expressions.preIncrementAssign(jDecl.parameter), (Statement)forBlock);
                if (!hasRows.equals(Expressions.constant(true))) {
                    forAggLoop = Expressions.ifThen(hasRows, forAggLoop);
                }
                builder5.add(forAggLoop);
            }
            if (EnumerableWindow.implementResult(aggs, builder5, resultContextBuilder, rexArguments, true)) {
                builder4.add(Expressions.ifThen(Expressions.orElse(lowerBoundCanChange, Expressions.notEqual(endX, prevEnd)), builder5.toBlock()));
            }
            EnumerableWindow.implementResult(aggs, builder4, resultContextBuilder, rexArguments, false);
            builder4.add(Expressions.statement(Expressions.call(list_, BuiltInMethod.COLLECTION_ADD.method, outputPhysType.record(outputRow))));
            builder3.add(Expressions.for_(Expressions.declare(0, i_, (Expression)Expressions.constant(0)), (Expression)Expressions.lessThan(i_, Expressions.field(rows_, "length")), (Expression)Expressions.preIncrementAssign(i_), (Statement)builder4.toBlock()));
            builder.add(Expressions.while_(Expressions.call(iterator_, BuiltInMethod.ITERATOR_HAS_NEXT.method, new Expression[0]), builder3.toBlock()));
            builder.add(Expressions.statement(Expressions.call(collectionExpr, BuiltInMethod.MAP_CLEAR.method, new Expression[0])));
            source_ = builder.append("source", Expressions.call(BuiltInMethod.AS_ENUMERABLE.method, list_));
            inputPhysType = outputPhysType;
        }
        builder.add(Expressions.return_(null, source_));
        return implementor.result(inputPhysType, builder.toBlock());
    }

    private static Function<BlockBuilder, WinAggFrameResultContext> getBlockBuilderWinAggFrameResultContextFunction(final JavaTypeFactory typeFactory, SqlConformance conformance, final EnumerableRel.Result result, final List<Expression> translatedConstants, Expression comparator_, Expression rows_, ParameterExpression i_, Expression startX, Expression endX, Expression minX, Expression maxX, Expression hasRows, Expression frameRowCount, Expression partitionRowCount, DeclarationStatement jDecl, final PhysType inputPhysType) {
        return block -> new WinAggFrameResultContext((BlockBuilder)block, conformance, jDecl, i_, startX, endX, hasRows, minX, maxX, comparator_, rows_, frameRowCount, partitionRowCount){
            final /* synthetic */ BlockBuilder val$block;
            final /* synthetic */ SqlConformance val$conformance;
            final /* synthetic */ DeclarationStatement val$jDecl;
            final /* synthetic */ ParameterExpression val$i_;
            final /* synthetic */ Expression val$startX;
            final /* synthetic */ Expression val$endX;
            final /* synthetic */ Expression val$hasRows;
            final /* synthetic */ Expression val$minX;
            final /* synthetic */ Expression val$maxX;
            final /* synthetic */ Expression val$comparator_;
            final /* synthetic */ Expression val$rows_;
            final /* synthetic */ Expression val$frameRowCount;
            final /* synthetic */ Expression val$partitionRowCount;
            {
                this.val$block = blockBuilder;
                this.val$conformance = sqlConformance;
                this.val$jDecl = declarationStatement;
                this.val$i_ = parameterExpression;
                this.val$startX = expression;
                this.val$endX = expression2;
                this.val$hasRows = expression3;
                this.val$minX = expression4;
                this.val$maxX = expression5;
                this.val$comparator_ = expression6;
                this.val$rows_ = expression7;
                this.val$frameRowCount = expression8;
                this.val$partitionRowCount = expression9;
            }

            @Override
            public RexToLixTranslator rowTranslator(Expression rowIndex) {
                Expression row = this.getRow(rowIndex);
                WindowRelInputGetter inputGetter = new WindowRelInputGetter(row, inputPhysType, result.physType.getRowType().getFieldCount(), translatedConstants);
                return RexToLixTranslator.forAggregation(typeFactory, this.val$block, inputGetter, this.val$conformance);
            }

            @Override
            public Expression computeIndex(Expression offset, WinAggImplementor.SeekType seekType) {
                Expression index;
                if (seekType == WinAggImplementor.SeekType.AGG_INDEX) {
                    index = this.val$jDecl.parameter;
                } else if (seekType == WinAggImplementor.SeekType.SET) {
                    index = this.val$i_;
                } else if (seekType == WinAggImplementor.SeekType.START) {
                    index = this.val$startX;
                } else if (seekType == WinAggImplementor.SeekType.END) {
                    index = this.val$endX;
                } else {
                    throw new IllegalArgumentException("SeekSet " + (Object)((Object)seekType) + " is not supported");
                }
                if (!Expressions.constant(0).equals(offset)) {
                    index = this.val$block.append("idx", Expressions.add(index, offset));
                }
                return index;
            }

            private Expression checkBounds(Expression rowIndex, Expression minIndex, Expression maxIndex) {
                if (rowIndex == this.val$i_ || rowIndex == this.val$startX || rowIndex == this.val$endX) {
                    return this.val$hasRows;
                }
                Expression res = this.val$block.append("rowInFrame", Expressions.foldAnd(ImmutableList.of(this.val$hasRows, Expressions.greaterThanOrEqual(rowIndex, minIndex), Expressions.lessThanOrEqual(rowIndex, maxIndex))));
                return res;
            }

            @Override
            public Expression rowInFrame(Expression rowIndex) {
                return this.checkBounds(rowIndex, this.val$startX, this.val$endX);
            }

            @Override
            public Expression rowInPartition(Expression rowIndex) {
                return this.checkBounds(rowIndex, this.val$minX, this.val$maxX);
            }

            @Override
            public Expression compareRows(Expression a, Expression b) {
                return Expressions.call(this.val$comparator_, BuiltInMethod.COMPARATOR_COMPARE.method, this.getRow(a), this.getRow(b));
            }

            public Expression getRow(Expression rowIndex) {
                return this.val$block.append("jRow", EnumUtils.convert(Expressions.arrayIndex(this.val$rows_, rowIndex), inputPhysType.getJavaRowType()));
            }

            @Override
            public Expression index() {
                return this.val$i_;
            }

            @Override
            public Expression startIndex() {
                return this.val$startX;
            }

            @Override
            public Expression endIndex() {
                return this.val$endX;
            }

            @Override
            public Expression hasRows() {
                return this.val$hasRows;
            }

            @Override
            public Expression getFrameRowCount() {
                return this.val$frameRowCount;
            }

            @Override
            public Expression getPartitionRowCount() {
                return this.val$partitionRowCount;
            }
        };
    }

    private static Pair<Expression, Expression> getPartitionIterator(BlockBuilder builder, Expression source_, PhysType inputPhysType, Window.Group group, Expression comparator_) {
        ParameterExpression key_;
        if (group.keys.isEmpty()) {
            Expression tempList_ = builder.append("tempList", Expressions.convert_(Expressions.call(source_, BuiltInMethod.INTO.method, Expressions.new_(ArrayList.class)), List.class));
            return Pair.of(tempList_, builder.append("iterator", Expressions.call(null, BuiltInMethod.SORTED_MULTI_MAP_SINGLETON.method, comparator_, tempList_)));
        }
        Expression multiMap_ = builder.append("multiMap", Expressions.new_(SortedMultiMap.class));
        BlockBuilder builder2 = new BlockBuilder();
        ParameterExpression v_ = Expressions.parameter(inputPhysType.getJavaRowType(), builder2.newName("v"));
        Pair<Type, List<Expression>> selector = inputPhysType.selector(v_, group.keys.asList(), JavaRowFormat.CUSTOM);
        if (selector.left instanceof Types.RecordType) {
            Types.RecordType keyJavaType = (Types.RecordType)selector.left;
            List initExpressions = (List)selector.right;
            key_ = Expressions.parameter(keyJavaType, "key");
            builder2.add(Expressions.declare(0, key_, null));
            builder2.add(Expressions.statement(Expressions.assign(key_, Expressions.new_(keyJavaType))));
            List<Types.RecordField> fieldList = keyJavaType.getRecordFields();
            for (int i = 0; i < initExpressions.size(); ++i) {
                Expression right = (Expression)initExpressions.get(i);
                builder2.add(Expressions.statement(Expressions.assign(Expressions.field((Expression)key_, fieldList.get(i)), right)));
            }
        } else {
            DeclarationStatement declare = Expressions.declare(0, "key", (Expression)((List)selector.right).get(0));
            builder2.add(declare);
            key_ = declare.parameter;
        }
        builder2.add(Expressions.statement(Expressions.call(multiMap_, BuiltInMethod.SORTED_MULTI_MAP_PUT_MULTI.method, key_, v_)));
        builder2.add(Expressions.return_(null, Expressions.constant(null)));
        builder.add(Expressions.statement(Expressions.call(source_, BuiltInMethod.ENUMERABLE_FOREACH.method, Expressions.lambda(builder2.toBlock(), v_))));
        return Pair.of(multiMap_, builder.append("iterator", Expressions.call(multiMap_, BuiltInMethod.SORTED_MULTI_MAP_ARRAYS.method, comparator_)));
    }

    private static Pair<@Nullable Expression, @Nullable Expression> getRowCollationKey(BlockBuilder builder, PhysType inputPhysType, Window.Group group, int windowIdx) {
        if (!(group.isRows || group.upperBound.isUnbounded() && group.lowerBound.isUnbounded())) {
            Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(group.collation().getFieldCollations());
            return Pair.of(builder.append("keySelector" + windowIdx, (Expression)pair.left, false), builder.append("keyComparator" + windowIdx, (Expression)pair.right, false));
        }
        return Pair.of(null, null);
    }

    private void declareAndResetState(final JavaTypeFactory typeFactory, BlockBuilder builder, final EnumerableRel.Result result, int windowIdx, List<AggImpState> aggs, PhysType outputPhysType, List<Expression> outputRow) {
        for (final AggImpState agg : aggs) {
            agg.context = new WinAggContext(){

                @Override
                public SqlAggFunction aggregation() {
                    return agg.call.getAggregation();
                }

                @Override
                public RelDataType returnRelType() {
                    return agg.call.type;
                }

                @Override
                public Type returnType() {
                    return EnumUtils.javaClass(typeFactory, this.returnRelType());
                }

                @Override
                public List<? extends Type> parameterTypes() {
                    return EnumUtils.fieldTypes(typeFactory, this.parameterRelTypes());
                }

                @Override
                public List<? extends RelDataType> parameterRelTypes() {
                    return EnumUtils.fieldRowTypes(result.physType.getRowType(), EnumerableWindow.this.constants, agg.call.getArgList());
                }

                @Override
                public List<ImmutableBitSet> groupSets() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public List<Integer> keyOrdinals() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public List<? extends RelDataType> keyRelTypes() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public List<? extends Type> keyTypes() {
                    throw new UnsupportedOperationException();
                }
            };
            String aggName = "a" + agg.aggIdx;
            if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
                aggName = Util.toJavaId(agg.call.getAggregation().getName(), 0).substring("ID$0$".length()) + aggName;
            }
            List<Type> state = agg.implementor.getStateType(agg.context);
            ArrayList<Expression> decls = new ArrayList<Expression>(state.size());
            for (int i = 0; i < state.size(); ++i) {
                Type type = state.get(i);
                ParameterExpression pe = Expressions.parameter(type, builder.newName(aggName + "s" + i + "w" + windowIdx));
                builder.add(Expressions.declare(0, pe, null));
                decls.add(pe);
            }
            agg.state = decls;
            Type aggHolderType = agg.context.returnType();
            Type aggStorageType = outputPhysType.getJavaFieldType(outputRow.size());
            if (Primitive.is(aggHolderType) && !Primitive.is(aggStorageType)) {
                aggHolderType = Primitive.box(aggHolderType);
            }
            ParameterExpression aggRes = Expressions.parameter(0, aggHolderType, builder.newName(aggName + "w" + windowIdx));
            builder.add(Expressions.declare(0, aggRes, (Expression)Expressions.constant(Optional.ofNullable(Primitive.of(aggRes.getType())).map(x -> x.defaultValue).orElse(null), aggRes.getType())));
            agg.result = aggRes;
            outputRow.add(aggRes);
            agg.implementor.implementReset(agg.context, new WinAggResetContextImpl(builder, agg.state, Nullness.castNonNull(null), Nullness.castNonNull(null), Nullness.castNonNull(null), Nullness.castNonNull(null), Nullness.castNonNull(null), Nullness.castNonNull(null)));
        }
    }

    private static void implementAdd(List<AggImpState> aggs, BlockBuilder builder7, Function<BlockBuilder, WinAggFrameResultContext> frame, final Function<AggImpState, List<RexNode>> rexArguments, final DeclarationStatement jDecl) {
        for (final AggImpState agg : aggs) {
            WinAggAddContextImpl addContext = new WinAggAddContextImpl(builder7, Objects.requireNonNull(agg.state, "agg.state"), frame){

                @Override
                public Expression currentPosition() {
                    return jDecl.parameter;
                }

                @Override
                public List<RexNode> rexArguments() {
                    return (List)rexArguments.apply(agg);
                }

                @Override
                public @Nullable RexNode rexFilterArgument() {
                    return null;
                }
            };
            agg.implementor.implementAdd(Objects.requireNonNull(agg.context, "agg.context"), addContext);
        }
    }

    private static boolean implementResult(List<AggImpState> aggs, BlockBuilder builder, Function<BlockBuilder, WinAggFrameResultContext> frame, final Function<AggImpState, List<RexNode>> rexArguments, boolean cachedBlock) {
        boolean nonEmpty = false;
        for (final AggImpState agg : aggs) {
            boolean needCache = true;
            if (agg.implementor instanceof WinAggImplementor) {
                WinAggImplementor imp = (WinAggImplementor)agg.implementor;
                needCache = imp.needCacheWhenFrameIntact();
            }
            if (needCache ^ cachedBlock) continue;
            nonEmpty = true;
            Expression res = agg.implementor.implementResult(Objects.requireNonNull(agg.context, "agg.context"), new WinAggResultContextImpl(builder, Objects.requireNonNull(agg.state, "agg.state"), frame){

                @Override
                public List<RexNode> rexArguments() {
                    return (List)rexArguments.apply(agg);
                }
            });
            Expression result = Objects.requireNonNull(agg.result, () -> "agg.result for " + agg.call);
            Expression aggRes = builder.append("a" + agg.aggIdx + "res", EnumUtils.convert(res, result.getType()));
            builder.add(Expressions.statement(Expressions.assign(result, aggRes)));
        }
        return nonEmpty;
    }

    private static Expression translateBound(RexToLixTranslator translator, ParameterExpression i_, Expression row_, Expression min_, Expression max_, Expression rows_, Window.Group group, boolean lower, PhysType physType, @Nullable Expression keySelector, @Nullable Expression keyComparator) {
        RexWindowBound bound;
        RexWindowBound rexWindowBound = bound = lower ? group.lowerBound : group.upperBound;
        if (bound.isUnbounded()) {
            return bound.isPreceding() ? min_ : max_;
        }
        if (group.isRows) {
            if (bound.isCurrentRow()) {
                return i_;
            }
            RexNode node = bound.getOffset();
            Expression offs = translator.translate(node);
            offs = EnumUtils.convert(offs, Integer.TYPE);
            Expression b = i_;
            b = bound.isFollowing() ? Expressions.add(b, offs) : Expressions.subtract(b, offs);
            return b;
        }
        Expression searchLower = min_;
        Expression searchUpper = max_;
        if (bound.isCurrentRow()) {
            if (lower) {
                searchUpper = i_;
            } else {
                searchLower = i_;
            }
        }
        List<RelFieldCollation> fieldCollations = group.collation().getFieldCollations();
        if (bound.isCurrentRow() && fieldCollations.size() != 1) {
            return Expressions.call((lower ? BuiltInMethod.BINARY_SEARCH5_LOWER : BuiltInMethod.BINARY_SEARCH5_UPPER).method, rows_, row_, searchLower, searchUpper, Objects.requireNonNull(keySelector, "keySelector"), Objects.requireNonNull(keyComparator, "keyComparator"));
        }
        assert (fieldCollations.size() == 1) : "When using range window specification, ORDER BY should have exactly one expression. Actual collation is " + group.collation();
        int orderKey = fieldCollations.get(0).getFieldIndex();
        RelDataType keyType = physType.getRowType().getFieldList().get(orderKey).getType();
        Type desiredKeyType = translator.typeFactory.getJavaClass(keyType);
        if (bound.getOffset() == null) {
            desiredKeyType = Primitive.box(desiredKeyType);
        }
        Expression val = translator.translate((RexNode)new RexInputRef(orderKey, keyType), desiredKeyType);
        if (!bound.isCurrentRow()) {
            RexNode node = bound.getOffset();
            Expression offs = translator.translate(node);
            val = bound.isFollowing() ? Expressions.add(val, offs) : Expressions.subtract(val, offs);
        }
        return Expressions.call((lower ? BuiltInMethod.BINARY_SEARCH6_LOWER : BuiltInMethod.BINARY_SEARCH6_UPPER).method, rows_, val, searchLower, searchUpper, Objects.requireNonNull(keySelector, "keySelector"), Objects.requireNonNull(keyComparator, "keyComparator"));
    }

    private static class WindowRelInputGetter
    implements RexToLixTranslator.InputGetter {
        private final Expression row;
        private final PhysType rowPhysType;
        private final int actualInputFieldCount;
        private final List<Expression> constants;

        private WindowRelInputGetter(Expression row, PhysType rowPhysType, int actualInputFieldCount, List<Expression> constants) {
            this.row = row;
            this.rowPhysType = rowPhysType;
            this.actualInputFieldCount = actualInputFieldCount;
            this.constants = constants;
        }

        @Override
        public Expression field(BlockBuilder list, int index, @Nullable Type storageType) {
            if (index < this.actualInputFieldCount) {
                Expression current = list.append("current", this.row);
                return this.rowPhysType.fieldReference(current, index, storageType);
            }
            return this.constants.get(index - this.actualInputFieldCount);
        }
    }
}

