/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.initializer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.kafka.source.enumerator.initializer.ReaderHandledOffsetsInitializer;
import org.apache.flink.connector.kafka.source.enumerator.initializer.SpecifiedOffsetsInitializer;
import org.apache.flink.connector.kafka.source.enumerator.initializer.TimestampOffsetsInitializer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;

@PublicEvolving
public interface OffsetsInitializer
extends Serializable {
    public Map<TopicPartition, Long> getPartitionOffsets(Collection<TopicPartition> var1, PartitionOffsetsRetriever var2);

    public OffsetResetStrategy getAutoOffsetResetStrategy();

    public static OffsetsInitializer committedOffsets() {
        return OffsetsInitializer.committedOffsets(OffsetResetStrategy.NONE);
    }

    public static OffsetsInitializer committedOffsets(OffsetResetStrategy offsetResetStrategy) {
        return new ReaderHandledOffsetsInitializer(-3L, offsetResetStrategy);
    }

    public static OffsetsInitializer timestamp(long timestamp) {
        return new TimestampOffsetsInitializer(timestamp);
    }

    public static OffsetsInitializer earliest() {
        return new ReaderHandledOffsetsInitializer(-2L, OffsetResetStrategy.EARLIEST);
    }

    public static OffsetsInitializer latest() {
        return new ReaderHandledOffsetsInitializer(-1L, OffsetResetStrategy.LATEST);
    }

    public static OffsetsInitializer offsets(Map<TopicPartition, Long> offsets) {
        return new SpecifiedOffsetsInitializer(offsets, OffsetResetStrategy.EARLIEST);
    }

    public static OffsetsInitializer offsets(Map<TopicPartition, Long> offsets, OffsetResetStrategy offsetResetStrategy) {
        return new SpecifiedOffsetsInitializer(offsets, offsetResetStrategy);
    }

    public static interface PartitionOffsetsRetriever {
        public Map<TopicPartition, Long> committedOffsets(Collection<TopicPartition> var1);

        public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> var1);

        public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> var1);

        public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> var1);
    }
}

