/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.gs;

import java.util.Optional;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.util.Preconditions;
import org.threeten.bp.Duration;

public class GSFileSystemOptions {
    public static final ConfigOption<String> WRITER_TEMPORARY_BUCKET_NAME = ConfigOptions.key((String)"gs.writer.temporary.bucket.name").stringType().noDefaultValue().withDescription("This option sets the bucket name used by the recoverable writer to store temporary files. If not specified, temporary files are stored in the same bucket as the final file being written.");
    public static final ConfigOption<MemorySize> WRITER_CHUNK_SIZE = ConfigOptions.key((String)"gs.writer.chunk.size").memoryType().noDefaultValue().withDescription("This option sets the chunk size for writes to the underlying Google storage. If set, this must be a multiple of 256KB. If not set, writes will use Google's default chunk size.");
    public static final ConfigOption<Boolean> ENABLE_FILESINK_ENTROPY = ConfigOptions.key((String)"gs.filesink.entropy.enabled").booleanType().defaultValue((Object)Boolean.FALSE).withDescription("This option can be used to improve performance due to hotspotting issues on GCS. If this is enabled, entropy in the form of temporary object id will be injected in the beginning of gcs path of the temporary objects. The final object path remains unchanged.");
    public static final ConfigOption<Integer> GCS_HTTP_CONNECT_TIMEOUT = ConfigOptions.key((String)"gs.http.connect-timeout").intType().noDefaultValue().withDescription("This option sets the timeout in milliseconds to establish a connection. GCS default will be used if not configured.");
    public static final ConfigOption<Integer> GCS_HTTP_READ_TIMEOUT = ConfigOptions.key((String)"gs.http.read-timeout").intType().noDefaultValue().withDescription("If configured this option sets the timeout in milliseconds to read data from an established connection. GCS default will be used if not configured");
    public static final ConfigOption<Integer> GCS_RETRY_MAX_ATTEMPT = ConfigOptions.key((String)"gs.retry.max-attempt").intType().noDefaultValue().withDescription(Description.builder().text("If configured this option defines the maximum number of retry attempts to perform. GCS default will be used if not configured. See GCS %s for more information.", new InlineElement[]{LinkElement.link((String)"https://cloud.google.com/java/docs/reference/gax/latest/com.google.api.gax.retrying.RetrySettings#com_google_api_gax_retrying_RetrySettings_getMaxAttempts__", (String)"documentation")}).build());
    public static final ConfigOption<java.time.Duration> GCS_RETRY_INIT_RPC_TIMEOUT = ConfigOptions.key((String)"gs.retry.init-rpc-timeout").durationType().noDefaultValue().withDescription(Description.builder().text("If configured this option controls the timeout for the initial RPC. Subsequent calls will use this value adjusted according to the gs.retry.rpc-timeout-multiplier. GCS default will be used if not configured. See GCS %s for more information.", new InlineElement[]{LinkElement.link((String)"https://cloud.google.com/java/docs/reference/gax/latest/com.google.api.gax.retrying.RetrySettings#com_google_api_gax_retrying_RetrySettings_getInitialRpcTimeout__", (String)"documentation")}).build());
    public static final ConfigOption<Double> GCS_RETRY_RPC_TIMEOUT_MULTIPLIER = ConfigOptions.key((String)"gs.retry.rpc-timeout-multiplier").doubleType().noDefaultValue().withDescription(Description.builder().text("If configured this option controls the change in delay before the next retry or poll. The timeout of the previous call is multiplied by the RpcTimeoutMultiplier to calculate the timeout for the next call. See GCS %s for more information.", new InlineElement[]{LinkElement.link((String)"https://cloud.google.com/java/docs/reference/gax/latest/com.google.api.gax.retrying.RetrySettings#com_google_api_gax_retrying_RetrySettings_getRpcTimeoutMultiplier__", (String)"documentation")}).build());
    public static final ConfigOption<java.time.Duration> GCS_RETRY_MAX_RPC_TIMEOUT = ConfigOptions.key((String)"gs.retry.max-rpc-timeout").durationType().noDefaultValue().withDescription(Description.builder().text("If configured this option puts a limit on the value of the RPC timeout, so that the max rpc timeout can't increase the RPC timeout higher than this amount. GCS default will be used if not configured. See GCS %s for more information.", new InlineElement[]{LinkElement.link((String)"https://cloud.google.com/java/docs/reference/gax/latest/com.google.api.gax.retrying.RetrySettings#com_google_api_gax_retrying_RetrySettings_getMaxRpcTimeout__", (String)"documentation")}).build());
    public static final ConfigOption<java.time.Duration> GCS_RETRY_TOTAL_TIMEOUT = ConfigOptions.key((String)"gs.retry.total-timeout").durationType().noDefaultValue().withDescription(Description.builder().text("If configured total duration during which retries could be attempted. GCS default will be used if not configured. See GCS %s for more information.", new InlineElement[]{LinkElement.link((String)"https://cloud.google.com/java/docs/reference/gax/latest/com.google.api.gax.retrying.RetrySettings#com_google_api_gax_retrying_RetrySettings_getTotalTimeout__", (String)"documentation")}).build());
    private final Configuration flinkConfig;

    public GSFileSystemOptions(Configuration flinkConfig) {
        this.flinkConfig = (Configuration)Preconditions.checkNotNull((Object)flinkConfig);
        this.flinkConfig.getOptional(WRITER_CHUNK_SIZE).ifPresent(chunkSize -> Preconditions.checkArgument((chunkSize.getBytes() > 0L && chunkSize.getBytes() % 262144L == 0L ? 1 : 0) != 0, (Object)"Writer chunk size must be greater than zero and a multiple of 256KB"));
    }

    public Optional<String> getWriterTemporaryBucketName() {
        return this.flinkConfig.getOptional(WRITER_TEMPORARY_BUCKET_NAME);
    }

    public Optional<Integer> getHTTPConnectionTimeout() {
        return this.flinkConfig.getOptional(GCS_HTTP_CONNECT_TIMEOUT);
    }

    public Optional<Integer> getHTTPReadTimeout() {
        return this.flinkConfig.getOptional(GCS_HTTP_READ_TIMEOUT);
    }

    public Optional<Integer> getMaxAttempts() {
        return this.flinkConfig.getOptional(GCS_RETRY_MAX_ATTEMPT);
    }

    public Optional<Duration> getInitialRpcTimeout() {
        return this.flinkConfig.getOptional(GCS_RETRY_INIT_RPC_TIMEOUT).map(timeout -> Duration.ofMillis(timeout.toMillis()));
    }

    public Optional<Double> getRpcTimeoutMultiplier() {
        return this.flinkConfig.getOptional(GCS_RETRY_RPC_TIMEOUT_MULTIPLIER);
    }

    public Optional<Duration> getMaxRpcTimeout() {
        return this.flinkConfig.getOptional(GCS_RETRY_MAX_RPC_TIMEOUT).map(timeout -> Duration.ofMillis(timeout.toMillis()));
    }

    public Optional<Duration> getTotalTimeout() {
        return this.flinkConfig.getOptional(GCS_RETRY_TOTAL_TIMEOUT).map(timeout -> Duration.ofMillis(timeout.toMillis()));
    }

    public Optional<MemorySize> getWriterChunkSize() {
        return this.flinkConfig.getOptional(WRITER_CHUNK_SIZE);
    }

    public Boolean isFileSinkEntropyEnabled() {
        return (Boolean)this.flinkConfig.get(ENABLE_FILESINK_ENTROPY);
    }

    public String toString() {
        return "GSFileSystemOptions{writerTemporaryBucketName=" + this.getWriterTemporaryBucketName() + ", writerChunkSize=" + this.getWriterChunkSize() + '}';
    }
}

