/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.writer;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.fs.RefCountedBufferingFileStream;
import org.apache.flink.core.fs.RefCountedFSOutputStream;
import org.apache.flink.core.fs.RefCountedFileWithStream;
import org.apache.flink.fs.osshadoop.writer.OSSCommitter;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverable;
import org.apache.flink.fs.osshadoop.writer.OSSRecoverableMultipartUpload;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.function.FunctionWithException;

@PublicEvolving
@NotThreadSafe
public class OSSRecoverableFsDataOutputStream
extends RecoverableFsDataOutputStream {
    private final ReentrantLock lock = new ReentrantLock();
    private long ossUploadPartSize;
    private FunctionWithException<File, RefCountedFileWithStream, IOException> cachedFileCreator;
    private RefCountedBufferingFileStream fileStream;
    private OSSRecoverableMultipartUpload upload;
    private long sizeBeforeCurrentPart;

    public OSSRecoverableFsDataOutputStream(long ossUploadPartSize, FunctionWithException<File, RefCountedFileWithStream, IOException> cachedFileCreator, OSSRecoverableMultipartUpload upload, long sizeBeforeCurrentPart) throws IOException {
        this.ossUploadPartSize = ossUploadPartSize;
        this.cachedFileCreator = cachedFileCreator;
        this.upload = upload;
        this.fileStream = upload.getIncompletePart().isPresent() ? RefCountedBufferingFileStream.restore(this.cachedFileCreator, (File)upload.getIncompletePart().get()) : RefCountedBufferingFileStream.openNew(this.cachedFileCreator);
        this.sizeBeforeCurrentPart = sizeBeforeCurrentPart;
    }

    public RecoverableWriter.ResumeRecoverable persist() throws IOException {
        this.lock();
        try {
            this.fileStream.flush();
            this.switchNewPartFileIfNecessary(this.ossUploadPartSize);
            OSSRecoverable oSSRecoverable = this.upload.getRecoverable((RefCountedFSOutputStream)this.fileStream);
            return oSSRecoverable;
        }
        finally {
            this.unlock();
        }
    }

    public RecoverableFsDataOutputStream.Committer closeForCommit() throws IOException {
        this.lock();
        try {
            this.uploadCurrentPart();
            OSSCommitter oSSCommitter = this.upload.getCommitter();
            return oSSCommitter;
        }
        finally {
            this.unlock();
        }
    }

    private void uploadCurrentPart() throws IOException {
        this.fileStream.flush();
        this.fileStream.close();
        if (this.fileStream.getPos() > 0L) {
            this.upload.uploadPart((RefCountedFSOutputStream)this.fileStream);
        }
        this.fileStream.release();
    }

    public long getPos() throws IOException {
        return this.sizeBeforeCurrentPart + this.fileStream.getPos();
    }

    public void write(int b) throws IOException {
        this.fileStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fileStream.write(b, off, len);
        this.switchNewPartFileIfNecessary(this.ossUploadPartSize);
    }

    public void flush() throws IOException {
        this.fileStream.flush();
        this.switchNewPartFileIfNecessary(this.ossUploadPartSize);
    }

    public void sync() throws IOException {
        this.fileStream.sync();
    }

    public void close() throws IOException {
        this.lock();
        try {
            this.fileStream.flush();
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)this.fileStream);
            this.fileStream.release();
            this.unlock();
        }
    }

    private void lock() throws IOException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("interrupted exception: " + e);
        }
    }

    private void unlock() {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchNewPartFileIfNecessary(long partSizeThreshold) throws IOException {
        long length = this.fileStream.getPos();
        if (length >= partSizeThreshold) {
            this.lock();
            try {
                this.sizeBeforeCurrentPart += this.fileStream.getPos();
                this.uploadCurrentPart();
                this.fileStream = RefCountedBufferingFileStream.openNew(this.cachedFileCreator);
            }
            finally {
                this.unlock();
            }
        }
    }
}

