/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.parser.JAXBResponseParser;
import com.aliyun.oss.common.parser.ResponseParseException;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.model.OSSErrorResult;

public class OSSCallbackErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage response) throws ServiceException, ClientException {
        if (response.getStatusCode() == 203) {
            JAXBResponseParser parser = new JAXBResponseParser(OSSErrorResult.class);
            try {
                try {
                    OSSErrorResult errorResult = (OSSErrorResult)parser.parse(response);
                    throw ExceptionFactory.createOSSException(errorResult, response.getErrorResponseAsString());
                }
                catch (ResponseParseException e) {
                    throw ExceptionFactory.createInvalidResponseException(response.getRequestId(), response.getErrorResponseAsString(), e);
                }
            }
            catch (Throwable throwable) {
                OSSUtils.safeCloseResponse(response);
                throw throwable;
            }
        }
    }
}

